package org.eclipse.draw2d.graph {
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.ArrayList;
import java.util.HashMap;
import java.lang.Double;
import java.lang.Arguments;
dynamic public class Vertex extends Point {
  public static const NOT_SET: int = 0;
  public static const INNIE: int = 1;
  public static const OUTIE: int = 2;
  internal var neighbors: List;
  internal var isPermanent: Boolean = false;
  internal var label: Vertex;
  internal var cost: Number = 0;
  internal var nearestObstacle: int = 0;
  internal var offset: Number = 0;
  internal var type: int = 0;
  internal var count: int = 0;
  internal var totalCount: int = 0;
  internal var obs: Obstacle;
  internal var paths: List;
  internal var nearestObstacleChecked: Boolean = false;
  internal var cachedCosines: Map;
  internal var positionOnObstacle: int = -1;
  private var origX: int;
  private var origY: int;
  public function Vertex__IILorg_eclipse_draw2d_graph_Obstacle_2(x: int, y: int, obs: Obstacle): Object {
    origX = x;
    origY = y;
    this.obs = obs;
    return this;
  }
  public function Vertex__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_graph_Obstacle_2(p: Point, obs: Obstacle): Object {
    return this;
  }
  public function addPath__Lorg_eclipse_draw2d_graph_Path_2Lorg_eclipse_draw2d_graph_Segment_2Lorg_eclipse_draw2d_graph_Segment_2(path: Path, start: Segment, end: Segment): void {
    if (paths === null) {
      paths = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
      cachedCosines = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
    }
    if (!paths.contains__Ljava_lang_Object_2(path))
      paths.add__Ljava_lang_Object_2(path);
    cachedCosines.put__Ljava_lang_Object_2Ljava_lang_Object_2(path, new Double(new Arguments(java.lang.Double.Double__D, [start.cosine__Lorg_eclipse_draw2d_graph_Segment_2(end)])));
    return;
  }
  public function bend__I(modifier: int): Point {
    var point: Point = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [x, y]));
    if ((positionOnObstacle & 1) > 0)
      point.y -= modifier * offset;
    else
      point.y += modifier * offset;
    if ((positionOnObstacle & 16) > 0)
      point.x += modifier * offset;
    else
      point.x -= modifier * offset;
    return point;
  }
  public function fullReset__(): void {
    totalCount = 0;
    type = 0;
    count = 0;
    cost = 0;
    offset = this.getSpacing__();
    nearestObstacle = 0;
    label = null;
    nearestObstacleChecked = false;
    isPermanent = false;
    if (neighbors !== null)
      neighbors.clear__();
    if (cachedCosines !== null)
      cachedCosines.clear__();
    if (paths !== null)
      paths.clear__();
  }
  public function getDeformedRectangle__I(extraOffset: int): Rectangle {
    var rect: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [0, 0, 0, 0]));
    if ((positionOnObstacle & 1) > 0) {
      rect.y = y - extraOffset;
      rect.height = origY - y + extraOffset;
    } else {
      rect.y = origY;
      rect.height = y - origY + extraOffset;
    }
    if ((positionOnObstacle & 16) > 0) {
      rect.x = origX;
      rect.width = x - origX + extraOffset;
    } else {
      rect.x = x - extraOffset;
      rect.width = origX - x + extraOffset;
    }
    return rect;
  }
  private function getSpacing__(): int {
    if (obs === null)
      return 0;
    return obs.getSpacing__();
  }
  public function grow__(): void {
    var modifier: int;
    if (nearestObstacle == 0)
      modifier = totalCount * this.getSpacing__();
    else
      modifier = (int(nearestObstacle / 2)) - 1;
    if ((positionOnObstacle & 1) > 0)
      y -= modifier;
    else
      y += modifier;
    if ((positionOnObstacle & 16) > 0)
      x += modifier;
    else
      x -= modifier;
  }
  public function shrink__(): void {
    x = origX;
    y = origY;
  }
  public function updateOffset__(): void {
    if (nearestObstacle != 0)
      offset = int(((int(nearestObstacle / 2)) - 1) / totalCount);
  }
  public override function toString__(): String {
    return "V(" + origX + ", " + origY + ")";
  }
  public function Vertex(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 3 && vargs[0] is int && vargs[1] is int && vargs[2] is Obstacle) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Point && vargs[1] is Obstacle) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1], args[2]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [args0[0], args0[1]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        args0 = [args1[0].x, args1[0].y, args1[1]];
        superArgs = new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [args0[0], args0[1]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Vertex__IILorg_eclipse_draw2d_graph_Obstacle_2(args0[0], args0[1], args0[2]);
        break;
      case 1:
        Vertex__IILorg_eclipse_draw2d_graph_Obstacle_2(args0[0], args0[1], args0[2]);
        Vertex__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_graph_Obstacle_2(args1[0], args1[1]);
        break;
    }
  }
  public static const Vertex__IILorg_eclipse_draw2d_graph_Obstacle_2 : int = 0;
  public static const Vertex__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_graph_Obstacle_2 : int = 1;
}
}
