package org.eclipse.draw2d.graph {
import org.eclipse.draw2d.geometry.Insets;
import java.lang.Math__;
import java.lang.JavaArray;
dynamic public class VerticalPlacement extends GraphVisitor {
  public override function visit__Lorg_eclipse_draw2d_graph_DirectedGraph_2(g: DirectedGraph): void {
    var pad: Insets;
    var currentY: int = g.getMargin__().top;
    var row: int;
    var rowHeight: int;
    g.rankLocations = new JavaArray("[I").lengths(g.ranks.size__() + 1);
    for (row = 0; row < g.ranks.size__(); row++) {
      g.rankLocations[row] = currentY;
      var rank: Rank = g.ranks.getRank__I(row);
      rowHeight = 0;
      rank.topPadding = rank.bottomPadding = 0;
      for (var n: int = 0; n < rank.size__(); n++) {
        var node: Node = rank.getNode__I(n);
        pad = g.getPadding__Lorg_eclipse_draw2d_graph_Node_2(node);
        rowHeight = Math__.max__II(node.height, rowHeight);
        rank.topPadding = Math__.max__II(pad.top, rank.topPadding);
        rank.bottomPadding = Math__.max__II(pad.bottom, rank.bottomPadding);
      }
      currentY += rank.topPadding;
      rank.setDimensions__II(currentY, rowHeight);
      currentY += rank.height + rank.bottomPadding;
    }
    g.rankLocations[row] = currentY;
    g.size.height = currentY;
    return;
  }
}
}
