package org.eclipse.draw2d.graph {
import org.eclipse.draw2d.geometry.Insets;
import java.lang.Arguments;
import java.lang.System;
dynamic public class VirtualNode extends Node {
  public var next: Node;
  public var prev: Node;
  public function VirtualNode__Lorg_eclipse_draw2d_graph_Edge_2I(e: Edge, i: int): Object {
    incoming.add__Ljava_lang_Object_2(e);
    outgoing.add__Ljava_lang_Object_2(e);
    width = e.width;
    height = 0;
    rank = i;
    this.setPadding__Lorg_eclipse_draw2d_geometry_Insets_2(new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__IIII, [0, e.padding, 0, e.padding])));
    return this;
  }
  public function VirtualNode__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Subgraph_2(o: Object, parent: Subgraph): Object {
    return this;
  }
  public function medianIncoming__(): Number {
    return prev.index;
  }
  public function medianOutgoing__(): Number {
    return next.index;
  }
  public function omega__(): int {
    var e: Edge = Edge(data);
    if (e.source.rank + 1 < rank && rank < e.target.rank)
      return 8 * e.weight;
    return 2 * e.weight;
  }
  public override function toString__(): String {
    if (data is Edge)
      return "VN[" + ((Edge(data)).vNodes.indexOf__Ljava_lang_Object_2(this) + 1) + "](" + java.lang.System.stringValueOf(data) + ")";
    return super.toString__();
  }
  public function VirtualNode(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 2 && vargs[0] is Edge && vargs[1] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Object && vargs[1] is Subgraph) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.draw2d.graph.Node.Node__Ljava_lang_Object_2, [args0[0]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.draw2d.graph.Node.Node__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Subgraph_2, [args1[0], args1[1]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        VirtualNode__Lorg_eclipse_draw2d_graph_Edge_2I(args0[0], args0[1]);
        break;
      case 1:
        VirtualNode__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Subgraph_2(args1[0], args1[1]);
        break;
    }
  }
  public static const VirtualNode__Lorg_eclipse_draw2d_graph_Edge_2I : int = 0;
  public static const VirtualNode__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Subgraph_2 : int = 1;
}
}
