package org.eclipse.draw2d.graph {
import org.eclipse.draw2d.geometry.Insets;
import java.lang.Arguments;
import java.lang.JavaArray;
import java.lang.System;
dynamic public class VirtualNodeCreation extends RevertableChange {
  private var edge: Edge;
  private var graph: DirectedGraph;
  private var nodes: JavaArray;
  private var edges: JavaArray;
  public static const INNER_EDGE_X: int = 2;
  public static const LONG_EDGE_X: int = 8;
  public function VirtualNodeCreation(edge: Edge, graph: DirectedGraph) {
    this.edge = edge;
    this.graph = graph;
    var size: int = edge.target.rank - edge.source.rank - 1;
    var offset: int = edge.source.rank + 1;
    var prevNode: Node = edge.source;
    var currentNode: Node;
    var currentEdge: Edge;
    nodes = new JavaArray("[Lorg/eclipse/draw2d/graph/Node;").lengths(size);
    edges = new JavaArray("[Lorg/eclipse/draw2d/graph/Edge;").lengths(size + 1);
    var padding: Insets = new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__IIII, [0, edge.padding, 0, edge.padding]));
    var s: Subgraph = GraphUtilities.getCommonAncestor__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2(edge.source, edge.target);
    for (var i: int = 0; i < size; i++) {
      nodes[i] = currentNode = new VirtualNode(new Arguments(org.eclipse.draw2d.graph.VirtualNode.VirtualNode__Ljava_lang_Object_2Lorg_eclipse_draw2d_graph_Subgraph_2, ["Virtual" + i + String.fromCharCode(58) + java.lang.System.stringValueOf(edge), s]));
      currentNode.width = edge.width;
      if (s !== null) {
        currentNode.nestingIndex = s.nestingIndex;
      }
      currentNode.height = 0;
      currentNode.setPadding__Lorg_eclipse_draw2d_geometry_Insets_2(padding);
      currentNode.rank = offset + i;
      graph.ranks.getRank__I(offset + i).add__Lorg_eclipse_draw2d_graph_Node_2(currentNode);
      currentEdge = new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II, [prevNode, currentNode, 1, edge.weight * 8]));
      if (i == 0) {
        currentEdge.weight = edge.weight * 2;
        currentEdge.offsetSource = edge.offsetSource;
      }
      graph.edges.add__Ljava_lang_Object_2(edges[i] = currentEdge);
      graph.nodes.add__Ljava_lang_Object_2(currentNode);
      prevNode = currentNode;
    }
    currentEdge = new Edge(new Arguments(org.eclipse.draw2d.graph.Edge.Edge__Lorg_eclipse_draw2d_graph_Node_2Lorg_eclipse_draw2d_graph_Node_2II, [prevNode, edge.target, 1, edge.weight * 2]));
    currentEdge.offsetTarget = edge.offsetTarget;
    graph.edges.add__Ljava_lang_Object_2(edges[edges.length - 1] = currentEdge);
    graph.removeEdge__Lorg_eclipse_draw2d_graph_Edge_2(edge);
    return;
  }
  public override function revert__(): void {
    edge.start = edges[0].start;
    edge.end = edges[edges.length - 1].end;
    edge.vNodes = new NodeList(new Arguments(org.eclipse.draw2d.graph.NodeList.NodeList__, []));
    for (var i: int = 0; i < edges.length; i++) {
      graph.removeEdge__Lorg_eclipse_draw2d_graph_Edge_2(edges[i]);
    }
    for (var i_1: int = 0; i_1 < nodes.length; i_1++) {
      edge.vNodes.add__Ljava_lang_Object_2(nodes[i_1]);
      graph.removeNode__Lorg_eclipse_draw2d_graph_Node_2(nodes[i_1]);
    }
    edge.source.outgoing.add__Ljava_lang_Object_2(edge);
    edge.target.incoming.add__Ljava_lang_Object_2(edge);
    graph.edges.add__Ljava_lang_Object_2(edge);
    return;
  }
}
}
