package org.eclipse.draw2d.parts {
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.MouseMotionListener$Stub;
import org.eclipse.draw2d.KeyListener$Stub;
import java.lang.Arguments;
dynamic public class ScrollableThumbnail extends Thumbnail {
  private var figureListener: FigureListener;
  private var keyListener: KeyListener;
  private var propListener: PropertyChangeListener;
  private var selector: ScrollableThumbnail$SelectorFigure;
  private var syncher: ScrollableThumbnail$ScrollSynchronizer;
  private var viewport: Viewport;
  public function ScrollableThumbnail__(): Object {
    figureListener = new org.eclipse.draw2d.parts.ScrollableThumbnail$1(ScrollableThumbnail(this));
    keyListener = new org.eclipse.draw2d.parts.ScrollableThumbnail$2(ScrollableThumbnail(this));
    propListener = new org.eclipse.draw2d.parts.ScrollableThumbnail$3(ScrollableThumbnail(this));
    this.initialize__();
    return this;
  }
  public function ScrollableThumbnail__Lorg_eclipse_draw2d_Viewport_2(port: Viewport): Object {
    figureListener = new ScrollableThumbnail$1(ScrollableThumbnail(this));
    keyListener = new ScrollableThumbnail$2(ScrollableThumbnail(this));
    propListener = new ScrollableThumbnail$3(ScrollableThumbnail(this));
    this.setViewport__Lorg_eclipse_draw2d_Viewport_2(port);
    this.initialize__();
    return this;
  }
  public override function deactivate__(): void {
    viewport.removePropertyChangeListener__Ljava_lang_String_2Ljava_beans_PropertyChangeListener_2("viewLocation", propListener);
    viewport.removeFigureListener__Lorg_eclipse_draw2d_FigureListener_2(figureListener);
    this.remove__Lorg_eclipse_draw2d_IFigure_2(selector);
    selector.dispose__();
    super.deactivate__();
  }
  private function getViewportScaleX__(): Number {
    return Number(targetSize.width) / viewport.getContents__().getBounds__().width;
  }
  private function getViewportScaleY__(): Number {
    return Number(targetSize.height) / viewport.getContents__().getBounds__().height;
  }
  private function initialize__(): void {
    selector = new ScrollableThumbnail$SelectorFigure(this);
    selector.addMouseListener__Lorg_eclipse_draw2d_MouseListener_2(syncher = new ScrollableThumbnail$ScrollSynchronizer(this));
    selector.addMouseMotionListener__Lorg_eclipse_draw2d_MouseMotionListener_2(syncher);
    selector.setFocusTraversable__Z(true);
    selector.addKeyListener__Lorg_eclipse_draw2d_KeyListener_2(keyListener);
    this.add__Lorg_eclipse_draw2d_IFigure_2(selector);
    var transferrer: ScrollableThumbnail$ClickScrollerAndDragTransferrer = new ScrollableThumbnail$ClickScrollerAndDragTransferrer(this);
    this.addMouseListener__Lorg_eclipse_draw2d_MouseListener_2(transferrer);
    this.addMouseMotionListener__Lorg_eclipse_draw2d_MouseMotionListener_2(transferrer);
  }
  private function reconfigureSelectorBounds__(): void {
    var rect: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, []));
    var offset: Point = viewport.getViewLocation__();
    offset.x -= viewport.getHorizontalRangeModel__().getMinimum__();
    offset.y -= viewport.getVerticalRangeModel__().getMinimum__();
    rect.setLocation__Lorg_eclipse_draw2d_geometry_Point_2(offset);
    rect.setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(viewport.getClientArea__().getSize__());
    rect.scale__DD(this.getViewportScaleX__(), this.getViewportScaleY__());
    rect.translate__Lorg_eclipse_draw2d_geometry_Point_2(this.getClientArea__().getLocation__());
    selector.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
  }
  public override function setScales__FF(scaleX_1: Number, scaleY_1: Number): void {
    if (scaleX_1 == this.getScaleX__() && scaleY_1 == this.getScaleY__())
      return;
    super.setScales__FF(scaleX_1, scaleY_1);
    this.reconfigureSelectorBounds__();
  }
  public function setViewport__Lorg_eclipse_draw2d_Viewport_2(port: Viewport): void {
    port.addPropertyChangeListener__Ljava_lang_String_2Ljava_beans_PropertyChangeListener_2("viewLocation", propListener);
    port.addFigureListener__Lorg_eclipse_draw2d_FigureListener_2(figureListener);
    viewport = port;
  }
  public static function access$0(arg0: ScrollableThumbnail): void {
    arg0.reconfigureSelectorBounds__();
  }
  public static function access$1(arg0: ScrollableThumbnail): Viewport {
    return arg0.viewport;
  }
  public static function access$2(arg0: ScrollableThumbnail): ScrollableThumbnail$ScrollSynchronizer {
    return arg0.syncher;
  }
  public static function access$3(arg0: ScrollableThumbnail): ScrollableThumbnail$SelectorFigure {
    return arg0.selector;
  }
  public static function access$4(arg0: ScrollableThumbnail): Number {
    return arg0.getViewportScaleX__();
  }
  public static function access$5(arg0: ScrollableThumbnail): Number {
    return arg0.getViewportScaleY__();
  }
  public function ScrollableThumbnail(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Viewport) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.draw2d.parts.Thumbnail.Thumbnail__, []);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.draw2d.parts.Thumbnail.Thumbnail__, []);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        ScrollableThumbnail__();
        break;
      case 1:
        ScrollableThumbnail__Lorg_eclipse_draw2d_Viewport_2(args1[0]);
        break;
    }
  }
  public static const ScrollableThumbnail__ : int = 0;
  public static const ScrollableThumbnail__Lorg_eclipse_draw2d_Viewport_2 : int = 1;
}
}
