package org.eclipse.draw2d.parts {
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Runnable;
import java.lang.Math__;
import org.eclipse.draw2d.geometry.Point;
import java.util.Map;
import java.util.Iterator;
import java.lang.Arguments;
dynamic public class Thumbnail$ThumbnailUpdater implements Runnable {
  public static const MAX_BUFFER_SIZE: int = 256;
  public var currentHTile: int;
  public var currentVTile: int;
  public var hTiles: int;
  public var vTiles: int;
  public var isActive: Boolean = true;
  public var isRunning: Boolean = false;
  public var thumbnailGC: GC;
  public var thumbnailGraphics: ScaledGraphics;
  public var tileSize: Dimension;
  private var this$0: Thumbnail;
  public function Thumbnail$ThumbnailUpdater(this$0: Thumbnail) {
    this.this$0 = this$0;
    return;
  }
  public function deactivate__(): void {
    this.setActive__Z(false);
    this.stop__();
    if (Thumbnail.access$0(this$0) !== null) {
      Thumbnail.access$0(this$0).dispose__();
      Thumbnail.access$1(this$0, null);
      Thumbnail.access$2(this$0, null);
    }
    return;
  }
  public function getCurrentHTile__(): int {
    return currentHTile;
  }
  public function getCurrentVTile__(): int {
    return currentVTile;
  }
  public function isActive__(): Boolean {
    return isActive;
  }
  public function isRunning__(): Boolean {
    return isRunning;
  }
  public function resetTileValues__(): void {
    hTiles = int(Math__.ceil__D(Number(this$0.getSourceRectangle__().width) / Number(256)));
    vTiles = int(Math__.ceil__D(Number(this$0.getSourceRectangle__().height) / Number(256)));
    tileSize = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [int(Math__.ceil__D(Number(this$0.getSourceRectangle__().width) / Number(hTiles))), int(Math__.ceil__D(Number(this$0.getSourceRectangle__().height) / Number(vTiles)))]));
    currentHTile = 0;
    currentVTile = 0;
  }
  public function restart__(): void {
    this.stop__();
    this.start__();
  }
  public function run__(): void {
    if (!this.isActive__() || !this.isRunning__())
      return;
    var v: int = this.getCurrentVTile__();
    var sy1: int = v * tileSize.height;
    var sy2: int = Math__.min__II((v + 1) * tileSize.height, this$0.getSourceRectangle__().height);
    var h: int = this.getCurrentHTile__();
    var sx1: int = h * tileSize.width;
    var sx2: int = Math__.min__II((h + 1) * tileSize.width, this$0.getSourceRectangle__().width);
    var p: Point = this$0.getSourceRectangle__().getLocation__();
    var rect: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [sx1 + p.x, sy1 + p.y, sx2 - sx1, sy2 - sy1]));
    thumbnailGraphics.pushState__();
    thumbnailGraphics.setClip__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
    thumbnailGraphics.fillRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
    Thumbnail.access$3(this$0).paint__Lorg_eclipse_draw2d_Graphics_2(thumbnailGraphics);
    thumbnailGraphics.popState__();
    if (this.getCurrentHTile__() < (hTiles - 1))
      this.setCurrentHTile__I(this.getCurrentHTile__() + 1);
    else {
      this.setCurrentHTile__I(0);
      if (this.getCurrentVTile__() < (vTiles - 1))
        this.setCurrentVTile__I(this.getCurrentVTile__() + 1);
      else
        this.setCurrentVTile__I(0);
    }
    if (this.getCurrentHTile__() != 0 || this.getCurrentVTile__() != 0)
      Display.getCurrent__().asyncExec__Ljava_lang_Runnable_2(this);
    else if (this$0.isDirty__()) {
      this$0.setDirty__Z(false);
      Display.getCurrent__().asyncExec__Ljava_lang_Runnable_2(this);
      this$0.repaint__();
    } else {
      this.stop__();
      this$0.repaint__();
    }
    return;
  }
  public function setActive__Z(value: Boolean): void {
    isActive = value;
    return;
  }
  public function setCurrentHTile__I(count: int): void {
    currentHTile = count;
    return;
  }
  public function setCurrentVTile__I(count: int): void {
    currentVTile = count;
    return;
  }
  public function start__(): void {
    if (!this.isActive__() || this.isRunning__())
      return;
    isRunning = true;
    this$0.setDirty__Z(false);
    this.resetTileValues__();
    if (!this$0.targetSize.equals__Ljava_lang_Object_2(Thumbnail.access$4(this$0))) {
      this.resetThumbnailImage__();
    }
    if (this$0.targetSize.isEmpty__())
      return;
    thumbnailGC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2I, [Thumbnail.access$0(this$0), Thumbnail.access$3(this$0).isMirrored__() ? 67108864 : 0]));
    thumbnailGraphics = new ScaledGraphics(new SWTGraphics(thumbnailGC));
    thumbnailGraphics.scale__D(this$0.getScaleX__());
    thumbnailGraphics.translate__Lorg_eclipse_draw2d_geometry_Point_2(this$0.getSourceRectangle__().getLocation__().negate__());
    var color: Color = Thumbnail.access$3(this$0).getForegroundColor__();
    if (color !== null)
      thumbnailGraphics.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(color);
    color = Thumbnail.access$3(this$0).getBackgroundColor__();
    if (color !== null)
      thumbnailGraphics.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(color);
    thumbnailGraphics.setFont__Lorg_eclipse_swt_graphics_Font_2(Thumbnail.access$3(this$0).getFont__());
    this$0.setScales__FF(this$0.targetSize.width / Number(this$0.getSourceRectangle__().width), this$0.targetSize.height / Number(this$0.getSourceRectangle__().height));
    Display.getCurrent__().asyncExec__Ljava_lang_Runnable_2(this);
  }
  private function resetThumbnailImage__(): void {
    if (Thumbnail.access$0(this$0) !== null)
      Thumbnail.access$0(this$0).dispose__();
    if (!this$0.targetSize.isEmpty__()) {
      Thumbnail.access$1(this$0, new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2II, [Display.getDefault__(), this$0.targetSize.width, this$0.targetSize.height])));
      Thumbnail.access$2(this$0, new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__Lorg_eclipse_draw2d_geometry_Dimension_2, [this$0.targetSize])));
    } else {
      Thumbnail.access$1(this$0, null);
      Thumbnail.access$2(this$0, new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [0, 0])));
    }
    return;
  }
  public function stop__(): void {
    isRunning = false;
    if (thumbnailGC !== null) {
      thumbnailGC.dispose__();
      thumbnailGC = null;
    }
    if (thumbnailGraphics !== null) {
      thumbnailGraphics.dispose__();
      thumbnailGraphics = null;
    }
    return;
  }
}
}
