package org.eclipse.draw2d.parts {
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Runnable;
import java.lang.Math__;
import org.eclipse.draw2d.geometry.Point;
import java.util.Map;
import java.util.Iterator;
import java.lang.Arguments;
dynamic public class Thumbnail extends Figure implements UpdateListener {
  private var isDirty: Boolean;
  private var scaleX: Number = 0;
  private var scaleY: Number = 0;
  private var sourceFigure: IFigure;
  internal var targetSize: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [0, 0]));
  private var thumbnailImage: Image;
  private var thumbnailImageSize: Dimension;
  private var updater: Thumbnail$ThumbnailUpdater = new Thumbnail$ThumbnailUpdater(Thumbnail(this));
  public function Thumbnail__(): Object {
    return this;
  }
  public function Thumbnail__Lorg_eclipse_draw2d_IFigure_2(fig: IFigure): Object {
    this.setSource__Lorg_eclipse_draw2d_IFigure_2(fig);
    return this;
  }
  private function adjustToAspectRatio__Lorg_eclipse_draw2d_geometry_Dimension_2Z(size: Dimension, adjustToMaxDimension: Boolean): Dimension {
    var sourceSize: Dimension = this.getSourceRectangle__().getSize__();
    var borderSize: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [this.getInsets__().getWidth__(), this.getInsets__().getHeight__()]));
    size.expand__Lorg_eclipse_draw2d_geometry_Dimension_2(borderSize.getNegated__());
    var width: int;
    var height: int;
    if (adjustToMaxDimension) {
      width = Math__.max__II(size.width, int((size.height * sourceSize.width / Number(sourceSize.height) + 0.5)));
      height = Math__.max__II(size.height, int((size.width * sourceSize.height / Number(sourceSize.width) + 0.5)));
    } else {
      width = Math__.min__II(size.width, int((size.height * sourceSize.width / Number(sourceSize.height) + 0.5)));
      height = Math__.min__II(size.height, int((size.width * sourceSize.height / Number(sourceSize.width) + 0.5)));
    }
    size.width = width;
    size.height = height;
    return size.expand__Lorg_eclipse_draw2d_geometry_Dimension_2(borderSize);
  }
  public function deactivate__(): void {
    sourceFigure.getUpdateManager__().removeUpdateListener__Lorg_eclipse_draw2d_UpdateListener_2(this);
    updater.deactivate__();
  }
  public override function getPreferredSize__II(wHint: int, hHint: int): Dimension {
    if (prefSize === null)
      return this.adjustToAspectRatio__Lorg_eclipse_draw2d_geometry_Dimension_2Z(this.getBounds__().getSize__(), false);
    var preferredSize: Dimension = this.adjustToAspectRatio__Lorg_eclipse_draw2d_geometry_Dimension_2Z(prefSize.getCopy__(), true);
    if (maxSize === null)
      return preferredSize;
    var maximumSize: Dimension = this.adjustToAspectRatio__Lorg_eclipse_draw2d_geometry_Dimension_2Z(maxSize.getCopy__(), true);
    if (preferredSize.contains__Lorg_eclipse_draw2d_geometry_Dimension_2(maximumSize))
      return maximumSize;
    else
      return preferredSize;
  }
  public function getScaleX__(): Number {
    return scaleX;
  }
  public function getScaleY__(): Number {
    return scaleY;
  }
  public function getSource__(): IFigure {
    return sourceFigure;
  }
  public function getSourceRectangle__(): Rectangle {
    return sourceFigure.getBounds__();
  }
  public function getThumbnailImage__(): Image {
    var oldSize: Dimension = targetSize;
    targetSize = this.getPreferredSize__();
    targetSize.expand__Lorg_eclipse_draw2d_geometry_Dimension_2(new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [this.getInsets__().getWidth__(), this.getInsets__().getHeight__()])).negate__());
    this.setScales__FF(targetSize.width / Number(this.getSourceRectangle__().width), targetSize.height / Number(this.getSourceRectangle__().height));
    if ((this.isDirty__()) && !updater.isRunning__())
      updater.start__();
    else if (oldSize !== null && !targetSize.equals__Ljava_lang_Object_2(oldSize)) {
      this.revalidate__();
      updater.restart__();
    }
    return thumbnailImage;
  }
  public function isDirty__(): Boolean {
    return isDirty;
  }
  public function notifyPainting__Lorg_eclipse_draw2d_geometry_Rectangle_2Ljava_util_Map_2(damage: Rectangle, dirtyRegions: Map): void {
    var dirtyFigures: Iterator = Iterator(dirtyRegions.keySet__().iterator__());
    while (dirtyFigures.hasNext__()) {
      var current: IFigure = IFigure(dirtyFigures.next__());
      while (current !== null) {
        if (current === this.getSource__()) {
          this.setDirty__Z(true);
          this.repaint__();
          return;
        }
        current = current.getParent__();
      }
    }
    return;
  }
  public function notifyValidating__(): void {
  }
  public override function paintFigure__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    var thumbnail: Image = this.getThumbnailImage__();
    if (thumbnail === null)
      return;
    graphics.drawImage__Lorg_eclipse_swt_graphics_Image_2Lorg_eclipse_draw2d_geometry_Point_2(thumbnail, this.getClientArea__().getLocation__());
  }
  public function setDirty__Z(value: Boolean): void {
    isDirty = value;
  }
  public function setScales__FF(x: Number, y: Number): void {
    scaleX = x;
    scaleY = y;
  }
  public function setSource__Lorg_eclipse_draw2d_IFigure_2(fig: IFigure): void {
    if (sourceFigure === fig)
      return;
    if (sourceFigure !== null)
      sourceFigure.getUpdateManager__().removeUpdateListener__Lorg_eclipse_draw2d_UpdateListener_2(this);
    sourceFigure = fig;
    if (sourceFigure !== null) {
      this.setScales__FF(Number(this.getSize__().width) / Number(this.getSourceRectangle__().width), Number(this.getSize__().height) / Number(this.getSourceRectangle__().height));
      sourceFigure.getUpdateManager__().addUpdateListener__Lorg_eclipse_draw2d_UpdateListener_2(this);
      this.repaint__();
    }
    return;
  }
  public static function access$0(arg0: Thumbnail): Image {
    return arg0.thumbnailImage;
  }
  public static function access$1(arg0: Thumbnail, arg1: Image): void {
    arg0.thumbnailImage = arg1;
  }
  public static function access$2(arg0: Thumbnail, arg1: Dimension): void {
    arg0.thumbnailImageSize = arg1;
  }
  public static function access$3(arg0: Thumbnail): IFigure {
    return arg0.sourceFigure;
  }
  public static function access$4(arg0: Thumbnail): Dimension {
    return arg0.thumbnailImageSize;
  }
  public function Thumbnail(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is IFigure) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Thumbnail__();
        break;
      case 1:
        Thumbnail__();
        Thumbnail__Lorg_eclipse_draw2d_IFigure_2(args1[0]);
        break;
    }
  }
  public static const Thumbnail__ : int = 0;
  public static const Thumbnail__Lorg_eclipse_draw2d_IFigure_2 : int = 1;
}
}
