package org.eclipse.draw2d.text {
import com.ibm.icu.text.Bidi;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.TextLayout;
import java.lang.StringBuffer;
import java.util.List;
import java.util.ArrayList;
import java.lang.System;
import java.lang.Character;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class BidiProcessor {
  public static var isMacOS: Boolean = Object(SWT.getPlatform__()).equals__Ljava_lang_Object_2("carbon");
  public static var INSTANCE: BidiProcessor = new BidiProcessor();
  private var bidiText: StringBuffer;
  private var list: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
  private var orientation: int = 33554432;
  function BidiProcessor() {
    return;
  }
  public function add__Lorg_eclipse_draw2d_text_FlowFigure_2Ljava_lang_String_2(fig: FlowFigure, str: String): void {
    list.add__Ljava_lang_Object_2(new BidiProcessor$BidiEntry(fig, bidiText.length__(), Object(str).length__()));
    bidiText.append__Ljava_lang_String_2(str);
    return;
  }
  public function add__Lorg_eclipse_draw2d_text_FlowFigure_2C(fig: FlowFigure, c: uint): void {
    list.add__Ljava_lang_Object_2(new BidiProcessor$BidiEntry(fig, bidiText.length__(), 1));
    bidiText.append__C(c);
    return;
  }
  public function addControlChar__C(c: uint): void {
    bidiText.append__C(c);
    return;
  }
  private function assignResults___3I(levels: JavaArray): void {
    var prevEntry: BidiProcessor$BidiEntry = null;
    var entry: BidiProcessor$BidiEntry = null;
    var prevInfo: BidiInfo = null;
    var info: BidiInfo = null;
    var end: int = 2;
    var start: int = 0;
    for (var i: int = 0; i < list.size__(); i++) {
      entry = BidiProcessor$BidiEntry(list.get__I(i));
      info = new BidiInfo();
      while (levels[end] < entry.end)
        end += 2;
      var levelInfo: JavaArray;
      if (end == start) {
        levelInfo = new JavaArray("[I").lengths(1);
        if (prevInfo !== null)
          levelInfo[0] = prevInfo.levelInfo[prevInfo.levelInfo.length - 1];
        else
          levelInfo[0] = (orientation == 33554432) ? 0 : 1;
      } else {
        levelInfo = new JavaArray("[I").lengths(end - start - 1);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(levels, start + 1, levelInfo, 0, levelInfo.length);
      }
      for (var j: int = 1; j < levelInfo.length; j += 2)
        levelInfo[j] -= entry.begin;
      info.levelInfo = levelInfo;
      if (prevEntry !== null) {
        if (levels[start] < entry.begin && levels[start + 1] % 2 == 1 && this.isJoiner__I(entry.begin) && this.isPrecedingJoiner__I(entry.begin))
          prevInfo.trailingJoiner = info.leadingJoiner = true;
        prevEntry.fig.setBidiInfo__Lorg_eclipse_draw2d_text_BidiInfo_2(prevInfo);
      }
      prevEntry = entry;
      prevInfo = info;
      if (entry.end == levels[end])
        start = end;
      else
        start = end - 2;
    }
    if (entry !== null)
      entry.fig.setBidiInfo__Lorg_eclipse_draw2d_text_BidiInfo_2(info);
    return;
  }
  private function isJoiner__I(begin: int): Boolean {
    return begin < bidiText.length__() && this.isJoiningCharacter__C(bidiText.charAt__I(begin));
  }
  private function isJoiningCharacter__C(c: uint): Boolean {
    return Character.getDirectionality__C(c) == 2 || c == 8205;
  }
  private function isPrecedingJoiner__I(begin: int): Boolean {
    return begin > 0 && this.isJoiningCharacter__C(bidiText.charAt__I(begin - 1));
  }
  public function process__(): void {
    try {
      if (bidiText.length__() == 0 || isMacOS)
        return;
      var chars: JavaArray = new JavaArray("[C").lengths(bidiText.length__());
      bidiText.getChars__II_3CI(0, bidiText.length__(), chars, 0);
      if (orientation != 67108864 && !Bidi.requiresBidi___3CII(chars, 0, chars.length - 1))
        return;
      var levels: JavaArray = new JavaArray("[I").lengths(15);
      var layout: org.eclipse.swt.graphics.TextLayout = FlowUtilities.getTextLayout__();
      layout.setOrientation__I(orientation);
      layout.setText__Ljava_lang_String_2(bidiText.toString__());
      var j: int = 0;
      var offset: int;
      var prevLevel: int = -1;
      for (offset = 0; offset < chars.length; offset++) {
        var newLevel: int = layout.getLevel__I(offset);
        if (newLevel != prevLevel) {
          if (j + 3 > levels.length) {
            var temp: JavaArray = levels;
            levels = new JavaArray("[I").lengths(levels.length * 2 + 1);
            System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(temp, 0, levels, 0, temp.length);
          }
          levels[j++] = offset;
          levels[j++] = newLevel;
          prevLevel = newLevel;
        }
      }
      levels[j++] = offset;
      if (j != levels.length) {
        var newLevels: JavaArray = new JavaArray("[I").lengths(j);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(levels, 0, newLevels, 0, j);
        levels = newLevels;
      }
      this.assignResults___3I(levels);
      layout.setOrientation__I(33554432);
    } finally {
      bidiText = null;
      list.clear__();
    }
    return;
  }
  public function setOrientation__I(newOrientation: int): void {
    bidiText = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__, []));
    list.clear__();
    orientation = newOrientation;
    return;
  }
}
}
