package org.eclipse.draw2d.text {
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import java.util.List;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class BlockFlow extends FlowFigure {
  private var blockBox: BlockBox;
  private var alignment: int = 0;
  private var orientation: int = 0;
  private var bidiValid: Boolean;
  public function BlockFlow() {
    blockBox = this.createBlockBox__();
    return;
  }
  public override function contributeBidi__Lorg_eclipse_draw2d_text_BidiProcessor_2(proc: BidiProcessor): void {
    proc.addControlChar__C(8233);
    return;
  }
  public function createBlockBox__(): BlockBox {
    return new BlockBox(this);
  }
  public override function createDefaultFlowLayout__(): FlowFigureLayout {
    return new BlockFlowLayout(this);
  }
  public function getBlockBox__(): BlockBox {
    return blockBox;
  }
  public function getBottomMargin__(): int {
    var margin: int = 0;
    if (this.getBorder__() is FlowBorder) {
      var border_1: FlowBorder = FlowBorder(this.getBorder__());
      return border_1.getBottomMargin__();
    }
    var children_1: List = this.getChildren__();
    var childIndex: int = children_1.size__() - 1;
    if (childIndex >= 0 && children_1.get__I(childIndex) is BlockFlow) {
      margin = Math__.max__II(margin, (BlockFlow(children_1.get__I(childIndex))).getBottomMargin__());
    }
    return margin;
  }
  public function getHorizontalAligment__(): int {
    if (alignment != 0)
      return alignment;
    var parent_1: IFigure = this.getParent__();
    while (parent_1 !== null && !(parent_1 is BlockFlow))
      parent_1 = parent_1.getParent__();
    if (parent_1 !== null)
      return (BlockFlow(parent_1)).getHorizontalAligment__();
    return 1;
  }
  public function getLeftMargin__(): int {
    if (this.getBorder__() is FlowBorder)
      return (FlowBorder(this.getBorder__())).getLeftMargin__();
    return 0;
  }
  public function getLocalOrientation__(): int {
    return orientation;
  }
  public function getLocalHorizontalAlignment__(): int {
    return alignment;
  }
  public function getOrientation__(): int {
    if (orientation != 0)
      return orientation;
    var parent_1: IFigure = this.getParent__();
    while (parent_1 !== null && !(parent_1 is BlockFlow))
      parent_1 = parent_1.getParent__();
    if (parent_1 !== null)
      return (BlockFlow(parent_1)).getOrientation__();
    return this.isMirrored__() ? 67108864 : 33554432;
  }
  public function getRightMargin__(): int {
    if (this.getBorder__() is FlowBorder)
      return (FlowBorder(this.getBorder__())).getRightMargin__();
    return 0;
  }
  public function getTopMargin__(): int {
    var margin: int = 0;
    if (this.getBorder__() is FlowBorder) {
      var border_1: FlowBorder = FlowBorder(this.getBorder__());
      return border_1.getTopMargin__();
    }
    var children_1: List = this.getChildren__();
    if (children_1.size__() > 0 && children_1.get__I(0) is BlockFlow) {
      margin = Math__.max__II(margin, (BlockFlow(children_1.get__I(0))).getTopMargin__());
    }
    return margin;
  }
  public override function paintBorder__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    if (this.getBorder__() is FlowBorder) {
      var where: Rectangle = this.getBlockBox__().toRectangle__();
      where.crop__Lorg_eclipse_draw2d_geometry_Insets_2(new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__IIII, [this.getTopMargin__(), this.getLeftMargin__(), this.getBottomMargin__(), this.getRightMargin__()])));
      (FlowBorder(this.getBorder__())).paint__Lorg_eclipse_draw2d_text_FlowFigure_2Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Rectangle_2I(this, graphics, where, 16384 | 131072);
    } else
      super.paintBorder__Lorg_eclipse_draw2d_Graphics_2(graphics);
    if (selectionStart != -1) {
      graphics.restoreState__();
      graphics.setXORMode__Z(true);
      graphics.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.white);
      graphics.fillRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.getBounds__());
    }
    return;
  }
  public override function postValidate__(): void {
    var newBounds: Rectangle = this.getBlockBox__().toRectangle__();
    newBounds.crop__Lorg_eclipse_draw2d_geometry_Insets_2(new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__IIII, [this.getTopMargin__(), this.getLeftMargin__(), this.getBottomMargin__(), this.getRightMargin__()])));
    this.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(newBounds);
    return;
  }
  public override function revalidate__(): void {
    var layout: BlockFlowLayout = BlockFlowLayout(this.getLayoutManager__());
    layout.blockContentsChanged__();
    super.revalidate__();
    return;
  }
  public override function revalidateBidi__Lorg_eclipse_draw2d_IFigure_2(origin: IFigure): void {
    if (bidiValid) {
      bidiValid = false;
      this.revalidate__();
    }
    return;
  }
  public function setHorizontalAligment__I(value: int): void {
    value &= 1 | 2 | 4 | 64 | 128;
    if (value == alignment)
      return;
    alignment = value;
    this.revalidate__();
  }
  public function setOrientation__I(orientation_1: int): void {
    orientation_1 &= 33554432 | 67108864;
    if (this.orientation == orientation_1)
      return;
    this.orientation = orientation_1;
    this.revalidateBidi__Lorg_eclipse_draw2d_IFigure_2(this);
  }
  public override function useLocalCoordinates__(): Boolean {
    return true;
  }
  public override function validate__(): void {
    if (!bidiValid) {
      BidiProcessor.INSTANCE.setOrientation__I(this.getOrientation__());
      if (this.getOrientation__() == 33554432 && this.isMirrored__())
        BidiProcessor.INSTANCE.addControlChar__C(8234);
      super.contributeBidi__Lorg_eclipse_draw2d_text_BidiProcessor_2(BidiProcessor.INSTANCE);
      BidiProcessor.INSTANCE.process__();
      bidiValid = true;
    }
    super.validate__();
    return;
  }
}
}
