package org.eclipse.draw2d.text {
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Insets;
import java.lang.Math__;
import java.lang.RuntimeException;
import java.util.List;
import java.lang.Integer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class BlockFlowLayout extends FlowContainerLayout {
  internal var blockBox: BlockBox;
  internal var blockInvalid: Boolean = false;
  private var continueOnSameLine: Boolean = false;
  private var previousLine: CompositeBox = null;
  public function BlockFlowLayout(blockFlow: BlockFlow) {
    super(blockFlow);
    return;
  }
  private function addBelowPreviousLine__Lorg_eclipse_draw2d_text_CompositeBox_2(line: CompositeBox): void {
    if (previousLine === null)
      line.setLineTop__I(line.getTopMargin__());
    else
      line.setLineTop__I(previousLine.getBaseline__() + previousLine.getDescent__() + Math__.max__II(previousLine.getBottomMargin__(), line.getTopMargin__()));
    var alignment: int = this.getBlockFlow__().getHorizontalAligment__();
    if (alignment == 1 || alignment == 4) {
      var orientation: int = this.getBlockFlow__().getOrientation__();
      if (alignment == 1)
        alignment = orientation == 33554432 ? 64 : 128;
      else
        alignment = orientation == 33554432 ? 128 : 64;
    }
    if (alignment != 2 && this.getBlockFlow__().isMirrored__())
      alignment = (64 | 128) & ~alignment;
    switch (alignment) {
      case 128 :
        line.setX__I(blockBox.getRecommendedWidth__() - line.getWidth__());
        break;
      case 2 :
        line.setX__I(int((blockBox.getRecommendedWidth__() - line.getWidth__()) / 2));
        break;
      case 64 :
        line.setX__I(0);
        break;
      default :
        throw new RuntimeException(new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, ["Unexpected state"]));
    }
    blockBox.add__Lorg_eclipse_draw2d_text_FlowBox_2(line);
    previousLine = line;
    return;
  }
  public function addCurrentLine__(): void {
    this.addBelowPreviousLine__Lorg_eclipse_draw2d_text_CompositeBox_2(currentLine);
    (LineRoot(currentLine)).commit__();
    return;
  }
  public override function addLine__Lorg_eclipse_draw2d_text_CompositeBox_2(box: CompositeBox): void {
    this.endLine__();
    this.addBelowPreviousLine__Lorg_eclipse_draw2d_text_CompositeBox_2(box);
    return;
  }
  public function blockContentsChanged__(): void {
    blockInvalid = true;
    return;
  }
  public override function cleanup__(): void {
    super.cleanup__();
    previousLine = null;
    return;
  }
  public override function createNewLine__(): void {
    currentLine = new LineRoot(this.getBlockFlow__().isMirrored__());
    currentLine.setRecommendedWidth__I(blockBox.getRecommendedWidth__());
    return;
  }
  public function endBlock__(): void {
    if (blockInvalid) {
      var insets: Insets = this.getBlockFlow__().getInsets__();
      blockBox.height += insets.getHeight__();
      blockBox.width += insets.getWidth__();
    }
    if (this.getContext__() !== null)
      this.getContext__().addLine__Lorg_eclipse_draw2d_text_CompositeBox_2(blockBox);
    if (blockInvalid) {
      blockInvalid = false;
      var v: List = this.getFlowFigure__().getChildren__();
      for (var i: int = 0; i < v.size__(); i++)
        (FlowFigure(v.get__I(i))).postValidate__();
    }
    return;
  }
  public override function endLine__(): void {
    if (currentLine === null || !currentLine.isOccupied__())
      return;
    this.addCurrentLine__();
    currentLine = null;
  }
  public override function flush__(): void {
    this.endLine__();
    this.endBlock__();
  }
  public override function forceChildInvalidation__Lorg_eclipse_draw2d_Figure_2(f: Figure): Boolean {
    return blockInvalid;
  }
  public function getBlockFlow__(): BlockFlow {
    return BlockFlow(this.getFlowFigure__());
  }
  public function getContextWidth__(): int {
    return this.getContext__().getRemainingLineWidth__();
  }
  public override function getContinueOnSameLine__(): Boolean {
    return continueOnSameLine;
  }
  public override function getWidthLookahead__Lorg_eclipse_draw2d_text_FlowFigure_2_3I(child: FlowFigure, result: JavaArray): void {
    var children: List = this.getFlowFigure__().getChildren__();
    var index: int = -1;
    if (child !== null)
      index = children.indexOf__Ljava_lang_Object_2(child);
    for (var i: int = index + 1; i < children.size__(); i++)
      if ((FlowFigure(children.get__I(i))).addLeadingWordRequirements___3I(result))
        return;
  }
  public override function preLayout__(): void {
    this.setContinueOnSameLine__Z(false);
    blockBox = this.getBlockFlow__().getBlockBox__();
    this.setupBlock__();
  }
  public override function setContinueOnSameLine__Z(value: Boolean): void {
    continueOnSameLine = value;
  }
  public function setupBlock__(): void {
    var recommended: int = this.getContextWidth__();
    if (recommended == 2147483647)
      recommended = -1;
    var bf: BlockFlow = this.getBlockFlow__();
    if (recommended > 0) {
      var borderCorrection: int = bf.getInsets__().getWidth__() + bf.getLeftMargin__() + bf.getRightMargin__();
      recommended = Math__.max__II(0, recommended - borderCorrection);
    }
    if (recommended != blockBox.recommendedWidth) {
      blockInvalid = true;
      blockBox.setRecommendedWidth__I(recommended);
    }
    if (blockInvalid) {
      blockBox.height = 0;
      blockBox.setWidth__I(Math__.max__II(0, recommended));
    }
    return;
  }
}
}
