package org.eclipse.draw2d.text {
import org.eclipse.draw2d.geometry.Translatable;
import java.lang.Arguments;
dynamic public class CaretInfo implements Translatable {
  private var ascent: int;
  private var lineAscent: int;
  private var descent: int;
  private var lineDescent: int;
  private var baseline: int;
  private var x: int;
  public function CaretInfo__IIIIII(x: int, y: int, ascent: int, descent: int, lineAscent: int, lineDescent: int): Object {
    this.x = x;
    this.baseline = y + ascent;
    this.ascent = ascent;
    this.descent = descent;
    this.lineAscent = lineAscent;
    this.lineDescent = lineDescent;
    return this;
  }
  public function CaretInfo__Lorg_eclipse_draw2d_text_CaretInfo_2(info: CaretInfo): Object {
    this.ascent = info.ascent;
    this.baseline = info.baseline;
    this.descent = info.descent;
    this.lineAscent = info.lineAscent;
    this.lineDescent = info.lineDescent;
    this.x = info.x;
    return this;
  }
  public function getBaseline__(): int {
    return baseline;
  }
  public function getHeight__(): int {
    return ascent + descent;
  }
  public function getLineHeight__(): int {
    return lineAscent + lineDescent;
  }
  public function getLineY__(): int {
    return baseline - lineAscent;
  }
  public function getX__(): int {
    return x;
  }
  public function getY__(): int {
    return baseline - ascent;
  }
  public function performScale__D(factor: Number): void {
    x *= factor;
    baseline *= factor;
    descent *= factor;
    ascent *= factor;
    lineAscent *= factor;
    lineDescent *= factor;
  }
  public function performTranslate__II(dx: int, dy: int): void {
    x += dx;
    baseline += dy;
  }
  public function CaretInfo(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 6 && vargs[0] is int && vargs[1] is int && vargs[2] is int && vargs[3] is int && vargs[4] is int && vargs[5] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is CaretInfo) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1], args[2], args[3], args[4], args[5]];
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        CaretInfo__IIIIII(args0[0], args0[1], args0[2], args0[3], args0[4], args0[5]);
        break;
      case 1:
        CaretInfo__Lorg_eclipse_draw2d_text_CaretInfo_2(args1[0]);
        break;
    }
  }
  public static const CaretInfo__IIIIII : int = 0;
  public static const CaretInfo__Lorg_eclipse_draw2d_text_CaretInfo_2 : int = 1;
}
}
