package org.eclipse.draw2d.text {
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import java.util.List;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class FlowPage extends BlockFlow {
  private var pageSize: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, []));
  private var recommendedWidth: int;
  private var pageSizeCacheKeys: JavaArray = new JavaArray("[I").lengths(3);
  private var pageSizeCacheValues: JavaArray = new JavaArray("[Lorg/eclipse/draw2d/geometry/Dimension;").lengths(3);
  public override function addNotify__(): void {
    super.addNotify__();
    this.setValid__Z(false);
    return;
  }
  public override function createDefaultFlowLayout__(): FlowFigureLayout {
    return new PageFlowLayout(this);
  }
  public override function getMinimumSize__II(w: int, h: int): Dimension {
    return this.getPreferredSize__II(w, h);
  }
  public override function invalidate__(): void {
    pageSizeCacheValues = new JavaArray("[Lorg/eclipse/draw2d/geometry/Dimension;").lengths(3);
    super.invalidate__();
  }
  public override function getPreferredSize__II(width: int, h: int): Dimension {
    for (var i: int = 0; i < 3; i++) {
      if (pageSizeCacheKeys[i] == width && pageSizeCacheValues[i] !== null)
        return pageSizeCacheValues[i];
    }
    pageSizeCacheKeys[2] = pageSizeCacheKeys[1];
    pageSizeCacheKeys[1] = pageSizeCacheKeys[0];
    pageSizeCacheKeys[0] = width;
    pageSizeCacheValues[2] = pageSizeCacheValues[1];
    pageSizeCacheValues[1] = pageSizeCacheValues[0];
    var oldWidth: int = this.getPageWidth__();
    this.setPageWidth__I(width);
    this.validate__();
    pageSizeCacheValues[0] = pageSize.getCopy__();
    if (width != oldWidth) {
      this.setPageWidth__I(oldWidth);
      this.getUpdateManager__().addInvalidFigure__Lorg_eclipse_draw2d_IFigure_2(this);
    }
    return pageSizeCacheValues[0];
  }
  public function getPageWidth__(): int {
    return recommendedWidth;
  }
  public override function postValidate__(): void {
    var r: Rectangle = this.getBlockBox__().toRectangle__();
    pageSize.width = r.width;
    pageSize.height = r.height;
    var v: List = this.getChildren__();
    for (var i: int = 0; i < v.size__(); i++)
      (FlowFigure(v.get__I(i))).postValidate__();
  }
  public override function removeNotify__(): void {
    super.removeNotify__();
    this.setValid__Z(true);
  }
  public override function setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(r: Rectangle): void {
    if (this.getBounds__().equals__Ljava_lang_Object_2(r))
      return;
    var invalidate: Boolean = this.getBounds__().width != r.width || this.getBounds__().height != r.height;
    super.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(r);
    var newWidth: int = r.width;
    if (invalidate || this.getPageWidth__() != newWidth) {
      this.setPageWidth__I(newWidth);
      this.getUpdateManager__().addInvalidFigure__Lorg_eclipse_draw2d_IFigure_2(this);
    }
    return;
  }
  private function setPageWidth__I(width: int): void {
    if (recommendedWidth == width)
      return;
    recommendedWidth = width;
    super.invalidate__();
  }
  public override function validate__(): void {
    if (this.isValid__())
      return;
    super.validate__();
    this.postValidate__();
  }
}
}
