package org.eclipse.draw2d.text {
import com.ibm.icu.text.BreakIterator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.TextUtilities;
import java.lang.Character;
import java.lang.Integer;
import java.lang.Math__;
dynamic public class FlowUtilities {
  public static var INSTANCE: FlowUtilities = new FlowUtilities();
  public static var INTERNAL_LINE_BREAK: BreakIterator = BreakIterator.getLineInstance__();
  public static var layout: org.eclipse.swt.graphics.TextLayout;
  public static var LINE_BREAK: BreakIterator = BreakIterator.getLineInstance__();
  public static function canBreakAfter__C(c: uint): Boolean {
    var result: Boolean = Character.isWhitespace__C(c) || c == 45;
    if (!result && (c < 97 || c > 122)) {
      LINE_BREAK.setText__Ljava_lang_String_2(String.fromCharCode(c) + "a");
      result = LINE_BREAK.isBoundary__I(1);
    }
    return result;
  }
  private static function findFirstDelimeter__Ljava_lang_String_2(string: String): int {
    var macNL: int = Object(string).indexOf__I(13);
    var unixNL: int = Object(string).indexOf__I(10);
    if (macNL == -1)
      macNL = 2147483647;
    if (unixNL == -1)
      unixNL = 2147483647;
    return Math__.min__II(macNL, unixNL);
  }
  public function getAverageCharWidth__Lorg_eclipse_draw2d_text_TextFragmentBox_2Lorg_eclipse_swt_graphics_Font_2(fragment: TextFragmentBox, font: Font): Number {
    if (fragment.getWidth__() > 0 && fragment.length != 0)
      return fragment.getWidth__() / Number(fragment.length);
    return FigureUtilities.getFontMetrics__Lorg_eclipse_swt_graphics_Font_2(font).getAverageCharWidth__();
  }
  public static function getBorderAscent__Lorg_eclipse_draw2d_text_InlineFlow_2(owner: InlineFlow): int {
    if (owner.getBorder__() is FlowBorder) {
      var border: FlowBorder = FlowBorder(owner.getBorder__());
      return border.getInsets__Lorg_eclipse_draw2d_IFigure_2(owner).top;
    }
    return 0;
  }
  public static function getBorderAscentWithMargin__Lorg_eclipse_draw2d_text_InlineFlow_2(owner: InlineFlow): int {
    if (owner.getBorder__() is FlowBorder) {
      var border: FlowBorder = FlowBorder(owner.getBorder__());
      return border.getTopMargin__() + border.getInsets__Lorg_eclipse_draw2d_IFigure_2(owner).top;
    }
    return 0;
  }
  public static function getBorderDescent__Lorg_eclipse_draw2d_text_InlineFlow_2(owner: InlineFlow): int {
    if (owner.getBorder__() is FlowBorder) {
      var border: FlowBorder = FlowBorder(owner.getBorder__());
      return border.getInsets__Lorg_eclipse_draw2d_IFigure_2(owner).bottom;
    }
    return 0;
  }
  public static function getBorderDescentWithMargin__Lorg_eclipse_draw2d_text_InlineFlow_2(owner: InlineFlow): int {
    if (owner.getBorder__() is FlowBorder) {
      var border: FlowBorder = FlowBorder(owner.getBorder__());
      return border.getBottomMargin__() + border.getInsets__Lorg_eclipse_draw2d_IFigure_2(owner).bottom;
    }
    return 0;
  }
  public static function getTextLayout__(): org.eclipse.swt.graphics.TextLayout {
    if (layout === null)
      layout = new org.eclipse.swt.graphics.TextLayout(Display.getDefault__());
    layout.setOrientation__I(33554432);
    return layout;
  }
  private static function initBidi__Lorg_eclipse_draw2d_text_TextFragmentBox_2Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(frag: TextFragmentBox, string: String, font: Font): void {
    if (frag.requiresBidi__()) {
      var textLayout: org.eclipse.swt.graphics.TextLayout = getTextLayout__();
      textLayout.setFont__Lorg_eclipse_swt_graphics_Font_2(font);
      textLayout.setText__Ljava_lang_String_2(string);
    }
    return;
  }
  private function measureString__Lorg_eclipse_draw2d_text_TextFragmentBox_2Ljava_lang_String_2ILorg_eclipse_swt_graphics_Font_2(frag: TextFragmentBox, string: String, guess: int, font: Font): int {
    if (frag.requiresBidi__()) {
      return this.getTextLayoutBounds__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2II(string, font, 0, guess - 1).width;
    } else
      return this.getTextUtilities__().getStringExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(Object(string).substring__II(0, guess), font).width;
  }
  public function setupFragment__Lorg_eclipse_draw2d_text_TextFragmentBox_2Lorg_eclipse_swt_graphics_Font_2Ljava_lang_String_2(fragment: TextFragmentBox, font: Font, string: String): void {
    if (fragment.getWidth__() == -1 || fragment.isTruncated__()) {
      var width: int;
      if (Object(string).length__() == 0 || fragment.length == 0)
        width = 0;
      else if (fragment.requiresBidi__()) {
        width = this.getTextLayoutBounds__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2II(string, font, 0, fragment.length - 1).width;
      } else
        width = this.getTextUtilities__().getStringExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(Object(string).substring__II(0, fragment.length), font).width;
      if (fragment.isTruncated__())
        width += this.getEllipsisWidth__Lorg_eclipse_swt_graphics_Font_2(font);
      fragment.setWidth__I(width);
    }
    return;
  }
  public function wrapFragmentInContext__Lorg_eclipse_draw2d_text_TextFragmentBox_2Ljava_lang_String_2Lorg_eclipse_draw2d_text_FlowContext_2Lorg_eclipse_draw2d_text_FlowUtilities$LookAhead_2Lorg_eclipse_swt_graphics_Font_2I(frag: TextFragmentBox, string: String, context: FlowContext, lookahead: FlowUtilities$LookAhead, font: Font, wrapping: int): int {
    frag.setTruncated__Z(false);
    var strLen: int = Object(string).length__();
    if (strLen == 0) {
      frag.setWidth__I(-1);
      frag.length = 0;
      this.setupFragment__Lorg_eclipse_draw2d_text_TextFragmentBox_2Lorg_eclipse_swt_graphics_Font_2Ljava_lang_String_2(frag, font, string);
      context.addToCurrentLine__Lorg_eclipse_draw2d_text_FlowBox_2(frag);
      return 0;
    }
    INTERNAL_LINE_BREAK.setText__Ljava_lang_String_2(string);
    FlowUtilities.initBidi__Lorg_eclipse_draw2d_text_TextFragmentBox_2Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(frag, string, font);
    var avgCharWidth: Number = this.getAverageCharWidth__Lorg_eclipse_draw2d_text_TextFragmentBox_2Lorg_eclipse_swt_graphics_Font_2(frag, font);
    frag.setWidth__I(-1);
    var absoluteMin: int = 0;
    var max: int;
    var min: int = 1;
    if (wrapping == 0) {
      absoluteMin = INTERNAL_LINE_BREAK.next__();
      while (absoluteMin > 0 && Character.isWhitespace__C(Object(string).charAt__I(absoluteMin - 1)))
        absoluteMin--;
      min = Math__.max__II(absoluteMin, 1);
    }
    var firstDelimiter: int = FlowUtilities.findFirstDelimeter__Ljava_lang_String_2(string);
    if (firstDelimiter == 0)
      min = max = 0;
    else
      max = Math__.min__II(strLen, firstDelimiter) + 1;
    var availableWidth: int = context.getRemainingLineWidth__();
    var guess: int = 0;
    var guessSize: int = 0;
    while (true) {
      if ((max - min) <= 1) {
        if (min == absoluteMin && context.isCurrentLineOccupied__() && !context.getContinueOnSameLine__() && availableWidth < this.measureString__Lorg_eclipse_draw2d_text_TextFragmentBox_2Ljava_lang_String_2ILorg_eclipse_swt_graphics_Font_2(frag, string, min, font) + ((min == strLen && lookahead !== null) ? lookahead.getWidth__() : 0)) {
          context.endLine__();
          availableWidth = context.getRemainingLineWidth__();
          max = Math__.min__II(strLen, firstDelimiter) + 1;
          if ((max - min) <= 1)
            break;
        } else
          break;
      }
      guess += 0.5 + (availableWidth - guessSize) / avgCharWidth;
      if (guess >= max)
        guess = max - 1;
      if (guess <= min)
        guess = min + 1;
      guessSize = this.measureString__Lorg_eclipse_draw2d_text_TextFragmentBox_2Ljava_lang_String_2ILorg_eclipse_swt_graphics_Font_2(frag, string, guess, font);
      if (guess == strLen && lookahead !== null && !FlowUtilities.canBreakAfter__C(Object(string).charAt__I(strLen - 1)) && guessSize + lookahead.getWidth__() > availableWidth) {
        max = guess;
        continue;
      }
      if (guessSize <= availableWidth) {
        min = guess;
        frag.setWidth__I(guessSize);
        if (guessSize == availableWidth)
          max = guess + 1;
      } else
        max = guess;
    }
    var result: int = min;
    var continueOnLine: Boolean = false;
    if (min == strLen) {
      if (Object(string).charAt__I(strLen - 1) == 32) {
        if (frag.getWidth__() == -1) {
          frag.length = result;
          frag.setWidth__I(this.measureString__Lorg_eclipse_draw2d_text_TextFragmentBox_2Ljava_lang_String_2ILorg_eclipse_swt_graphics_Font_2(frag, string, result, font));
        }
        if (lookahead.getWidth__() > availableWidth - frag.getWidth__()) {
          frag.length = result - 1;
          frag.setWidth__I(-1);
        } else
          frag.length = result;
      } else {
        continueOnLine = !FlowUtilities.canBreakAfter__C(Object(string).charAt__I(strLen - 1));
        frag.length = result;
      }
    } else if (min == firstDelimiter) {
      frag.length = result;
      if (Object(string).charAt__I(min) == 13) {
        result++;
        if (++min < strLen && Object(string).charAt__I(min) == 10)
          result++;
      } else if (Object(string).charAt__I(min) == 10)
        result++;
    } else if (Object(string).charAt__I(min) == 32 || FlowUtilities.canBreakAfter__C(Object(string).charAt__I(min - 1)) || INTERNAL_LINE_BREAK.isBoundary__I(min)) {
      frag.length = min;
      if (Object(string).charAt__I(min) == 32)
        result++;
      else if (Object(string).charAt__I(min - 1) == 32) {
        frag.length--;
        frag.setWidth__I(-1);
      }
    } else
      out: {
        result = INTERNAL_LINE_BREAK.preceding__I(min);
        if (result == 0) {
          switch (wrapping) {
            case 2 :
              var truncatedWidth: int = availableWidth - this.getEllipsisWidth__Lorg_eclipse_swt_graphics_Font_2(font);
              if (truncatedWidth > 0) {
                while (min > 0) {
                  guessSize = this.measureString__Lorg_eclipse_draw2d_text_TextFragmentBox_2Ljava_lang_String_2ILorg_eclipse_swt_graphics_Font_2(frag, string, min, font);
                  if (guessSize <= truncatedWidth)
                    break;
                  min--;
                }
                frag.length = min;
              } else
                frag.length = 0;
              frag.setTruncated__Z(true);
              result = INTERNAL_LINE_BREAK.following__I(max - 1);
              break out;
            default :
              result = min;
              break;
          }
        }
        frag.length = result;
        if (Object(string).charAt__I(result - 1) == 32)
          frag.length--;
        frag.setWidth__I(-1);
      }
    this.setupFragment__Lorg_eclipse_draw2d_text_TextFragmentBox_2Lorg_eclipse_swt_graphics_Font_2Ljava_lang_String_2(frag, font, string);
    context.addToCurrentLine__Lorg_eclipse_draw2d_text_FlowBox_2(frag);
    context.setContinueOnSameLine__Z(continueOnLine);
    return result;
  }
  public function getTextLayoutBounds__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2II(s: String, f: Font, start: int, end: int): Rectangle {
    var textLayout: org.eclipse.swt.graphics.TextLayout = FlowUtilities.getTextLayout__();
    textLayout.setFont__Lorg_eclipse_swt_graphics_Font_2(f);
    textLayout.setText__Ljava_lang_String_2(s);
    return textLayout.getBounds__II(start, end);
  }
  public function getTextUtilities__(): TextUtilities {
    return TextUtilities.INSTANCE;
  }
  private function getEllipsisWidth__Lorg_eclipse_swt_graphics_Font_2(font: Font): int {
    return this.getTextUtilities__().getStringExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2("...", font).width;
  }
}
}
