package org.eclipse.draw2d.text {
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.lang.Integer;
import java.lang.Math__;
import java.lang.RuntimeException;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class InlineFlow extends FlowFigure {
  internal var fragments: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__I, [1]));
  public override function addLeadingWordRequirements___3I(width: JavaArray): Boolean {
    var iter: Iterator = Iterator(this.getChildren__().iterator__());
    while (iter.hasNext__()) {
      if ((FlowFigure(iter.next__())).addLeadingWordRequirements___3I(width))
        return true;
    }
    return false;
  }
  public override function containsPoint__II(x: int, y: int): Boolean {
    if (super.containsPoint__II(x, y)) {
      var frags: List = this.getFragments__();
      for (var i: int = 0; i < frags.size__(); i++)
        if ((FlowBox(frags.get__I(i))).containsPoint__II(x, y))
          return true;
    }
    return false;
  }
  public override function createDefaultFlowLayout__(): FlowFigureLayout {
    return new InlineFlowLayout(this);
  }
  public function getFragments__(): List {
    return fragments;
  }
  public override function paintBorder__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    if (this.getBorder__() !== null) {
      var fb: FlowBorder = FlowBorder(this.getBorder__());
      var frags: List = this.getFragments__();
      var where: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, []));
      var sides: int;
      for (var i: int = 0; i < frags.size__(); i++) {
        var box: FlowBox = FlowBox(frags.get__I(i));
        where.x = box.getX__();
        where.width = box.getWidth__();
        where.y = -box.getAscentWithBorder__();
        where.height = box.getDescentWithBorder__() - where.y;
        where.y += box.getBaseline__();
        sides = 0;
        if (i == 0)
          sides = 16384;
        if (i == frags.size__() - 1)
          sides |= 131072;
        fb.paint__Lorg_eclipse_draw2d_text_FlowFigure_2Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Rectangle_2I(this, graphics, where, sides);
      }
      graphics.restoreState__();
    }
    if (selectionStart != -1)
      this.paintSelection__Lorg_eclipse_draw2d_Graphics_2(graphics);
    return;
  }
  public function paintSelection__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    graphics.restoreState__();
    graphics.setXORMode__Z(true);
    graphics.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.white);
    var list: List = this.getFragments__();
    var box: FlowBox;
    for (var i: int = 0; i < list.size__(); i++) {
      box = FlowBox(list.get__I(i));
      var top: int = box.getLineRoot__().getVisibleTop__();
      var bottom: int = box.getLineRoot__().getVisibleBottom__();
      graphics.fillRectangle__IIII(box.getX__(), top, box.getWidth__(), bottom - top);
    }
    return;
  }
  public override function postValidate__(): void {
    var list: List = this.getFragments__();
    var box: FlowBox;
    var left: int = 2147483647;
    var top: int = left;
    var right: int = -2147483648;
    var bottom: int = right;
    for (var i: int = 0; i < list.size__(); i++) {
      box = FlowBox(list.get__I(i));
      left = Math__.min__II(left, box.getX__());
      right = Math__.max__II(right, box.getX__() + box.getWidth__());
      top = Math__.min__II(top, box.getLineRoot__().getVisibleTop__());
      bottom = Math__.max__II(bottom, box.getLineRoot__().getVisibleBottom__());
    }
    this.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [left, top, right - left, bottom - top])));
    this.repaint__();
    list = this.getChildren__();
    for (var i_1: int = 0; i_1 < list.size__(); i_1++)
      (FlowFigure(list.get__I(i_1))).postValidate__();
    return;
  }
  public override function setBorder__Lorg_eclipse_draw2d_Border_2(border_1: Border): void {
    if (border_1 === null || border_1 is FlowBorder)
      super.setBorder__Lorg_eclipse_draw2d_Border_2(border_1);
    else
      throw new RuntimeException(new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, ["Border must be an instance of FlowBorder"]));
    return;
  }
}
}
