package org.eclipse.draw2d.text {
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.List;
import java.util.ArrayList;
import java.lang.Math__;
import java.lang.Integer;
import java.util.Iterator;
import java.lang.Arguments;
dynamic public class LineBox extends CompositeBox {
  internal var contentAscent: int;
  internal var contentDescent: int;
  internal var fragments: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
  public override function add__Lorg_eclipse_draw2d_text_FlowBox_2(child: FlowBox): void {
    fragments.add__Ljava_lang_Object_2(child);
    width += child.getWidth__();
    contentAscent = Math__.max__II(contentAscent, child.getOuterAscent__());
    contentDescent = Math__.max__II(contentDescent, child.getOuterDescent__());
    return;
  }
  public override function getAscent__(): int {
    var ascent: int = 0;
    for (var i: int = 0; i < fragments.size__(); i++)
      ascent = Math__.max__II(ascent, (FlowBox(fragments.get__I(i))).getAscent__());
    return ascent;
  }
  public function getAvailableWidth__(): int {
    if (recommendedWidth < 0)
      return 2147483647;
    return recommendedWidth - this.getWidth__();
  }
  public override function getBottomMargin__(): int {
    return 0;
  }
  public override function getDescent__(): int {
    var descent: int = 0;
    for (var i: int = 0; i < fragments.size__(); i++)
      descent = Math__.max__II(descent, (FlowBox(fragments.get__I(i))).getDescent__());
    return descent;
  }
  public function getFragments__(): List {
    return fragments;
  }
  public override function getTopMargin__(): int {
    return 0;
  }
  public function isOccupied__(): Boolean {
    return !fragments.isEmpty__();
  }
  public override function requiresBidi__(): Boolean {
    for (var iter: Iterator = Iterator(this.getFragments__().iterator__()); iter.hasNext__();) {
      var box: FlowBox = FlowBox(iter.next__());
      if (box.requiresBidi__())
        return true;
    }
    return false;
  }
}
}
