package org.eclipse.draw2d.text {
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.lang.Arguments;
dynamic public class LineRoot extends LineBox {
  private var baseline: int;
  private var isMirrored: Boolean;
  public function LineRoot(isMirrored: Boolean) {
    this.isMirrored = isMirrored;
    return;
  }
  public override function add__Lorg_eclipse_draw2d_text_FlowBox_2(child: FlowBox): void {
    super.add__Lorg_eclipse_draw2d_text_FlowBox_2(child);
    child.setLineRoot__Lorg_eclipse_draw2d_text_LineRoot_2(this);
  }
  private function bidiCommit__(): void {
    var xLocation: int = this.getX__();
    var root: LineRoot$BidiLevelNode = new LineRoot$BidiLevelNode(new Arguments(org.eclipse.draw2d.text.LineRoot$BidiLevelNode.LineRoot$BidiLevelNode__, []));
    var branches: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    this.buildBidiTree__Lorg_eclipse_draw2d_text_FlowBox_2Lorg_eclipse_draw2d_text_LineRoot$BidiLevelNode_2Ljava_util_List_2(this, root, branches);
    var result: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    root.emit__Ljava_util_List_2(result);
    var i: int = isMirrored ? result.size__() - 1 : 0;
    while (i >= 0 && i < result.size__()) {
      var box: FlowBox = FlowBox(result.get__I(i));
      box.setX__I(xLocation);
      xLocation += box.getWidth__();
      i += isMirrored ? -1 : 1;
    }
    this.layoutNestedLines__Ljava_util_List_2(branches);
    return;
  }
  private function buildBidiTree__Lorg_eclipse_draw2d_text_FlowBox_2Lorg_eclipse_draw2d_text_LineRoot$BidiLevelNode_2Ljava_util_List_2(box: FlowBox, node: LineRoot$BidiLevelNode, branches: List): void {
    if (box is LineBox) {
      var children: List = (LineBox(box)).getFragments__();
      for (var i: int = 0; i < children.size__(); i++)
        this.buildBidiTree__Lorg_eclipse_draw2d_text_FlowBox_2Lorg_eclipse_draw2d_text_LineRoot$BidiLevelNode_2Ljava_util_List_2(FlowBox(children.get__I(i)), node, branches);
      if (box !== this)
        branches.add__Ljava_lang_Object_2(box);
    } else {
      var leafBox: ContentBox = ContentBox(box);
      while (leafBox.getBidiLevel__() < node.level)
        node = node.pop__();
      while (leafBox.getBidiLevel__() > node.level)
        node = node.push__();
      node.add__Ljava_lang_Object_2(leafBox);
    }
    return;
  }
  public function commit__(): void {
    if (this.requiresBidi__())
      this.bidiCommit__();
    else
      this.contiguousCommit__Lorg_eclipse_draw2d_text_FlowBox_2I(this, this.getX__());
    return;
  }
  public override function containsPoint__II(x_1: int, y: int): Boolean {
    return false;
  }
  private function contiguousCommit__Lorg_eclipse_draw2d_text_FlowBox_2I(box: FlowBox, x_1: int): void {
    box.setX__I(x_1);
    if (box is LineBox) {
      var fragments_1: List = (LineBox(box)).getFragments__();
      var i: int = isMirrored ? fragments_1.size__() - 1 : 0;
      while (i >= 0 && i < fragments_1.size__()) {
        var child: FlowBox = FlowBox(fragments_1.get__I(i));
        this.contiguousCommit__Lorg_eclipse_draw2d_text_FlowBox_2I(child, x_1);
        x_1 += child.getWidth__();
        i += isMirrored ? -1 : 1;
      }
    }
    return;
  }
  private function findParent__Lorg_eclipse_draw2d_text_NestedLine_2Ljava_util_List_2I(line: NestedLine, branches: List, afterIndex: int): LineRoot$Result {
    for (var i: int = afterIndex + 1; i < branches.size__(); i++) {
      var box: NestedLine = NestedLine(branches.get__I(i));
      var index: int = box.getFragments__().indexOf__Ljava_lang_Object_2(line);
      if (index >= 0)
        return new LineRoot$Result(box, index);
    }
    return new LineRoot$Result(this, this.getFragments__().indexOf__Ljava_lang_Object_2(line));
  }
  public override function getBaseline__(): int {
    return baseline;
  }
  public override function getLineRoot__(): LineRoot {
    return this;
  }
  public function getVisibleBottom__(): int {
    return baseline + contentDescent;
  }
  public function getVisibleTop__(): int {
    return baseline - contentAscent;
  }
  private function layoutNestedLines__Ljava_util_List_2(branches: List): void {
    for (var i: int = 0; i < branches.size__(); i++) {
      var parent: NestedLine = NestedLine(branches.get__I(i));
      var prevChild: FlowBox = null;
      var bounds: Rectangle = null;
      var frags: List = parent.getFragments__();
      for (var j: int = 0; j < frags.size__(); j++) {
        var child: FlowBox = FlowBox(frags.get__I(j));
        if (prevChild !== null && prevChild.getX__() + prevChild.width != child.getX__() && child.getX__() + child.width != prevChild.getX__()) {
          var parentFig: InlineFlow = parent.owner;
          var newBox: NestedLine = new NestedLine(parentFig);
          newBox.setLineRoot__Lorg_eclipse_draw2d_text_LineRoot_2(this);
          for (var k: int = j; k < frags.size__();)
            newBox.fragments.add__Ljava_lang_Object_2(frags.remove__I(k));
          var result: LineRoot$Result = this.findParent__Lorg_eclipse_draw2d_text_NestedLine_2Ljava_util_List_2I(parent, branches, i);
          result.parent.getFragments__().add__ILjava_lang_Object_2(result.index + 1, newBox);
          parentFig.fragments.add__ILjava_lang_Object_2(parentFig.fragments.indexOf__Ljava_lang_Object_2(parent) + 1, newBox);
          branches.add__ILjava_lang_Object_2(i + 1, newBox);
          break;
        }
        if (bounds === null)
          bounds = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [child.getX__(), 1, child.getWidth__(), 1]));
        else
          bounds.union__IIII(child.getX__(), 1, child.getWidth__(), 1);
        prevChild = child;
      }
      parent.setX__I(bounds.x);
      parent.setWidth__I(bounds.width);
    }
    return;
  }
  public function setBaseline__I(baseline_1: int): void {
    this.baseline = baseline_1;
    return;
  }
  public override function setLineTop__I(top: int): void {
    this.baseline = top + this.getAscent__();
    return;
  }
}
}
