package org.eclipse.draw2d.text {
import java.util.List;
import org.eclipse.swt.graphics.Font;
import java.util.List;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ParagraphTextLayout extends TextLayout {
  public static const WORD_WRAP_HARD: int = 0;
  public static const WORD_WRAP_SOFT: int = 1;
  public static const WORD_WRAP_TRUNCATE: int = 2;
  private var wrappingStyle: int = 0;
  public function ParagraphTextLayout__Lorg_eclipse_draw2d_text_TextFlow_2(flow: TextFlow): Object {
    return this;
  }
  public function ParagraphTextLayout__Lorg_eclipse_draw2d_text_TextFlow_2I(flow: TextFlow, style: int): Object {
    wrappingStyle = style;
    return this;
  }
  private function getSegments__Ljava_lang_String_2_3I(text: String, levelInfo: JavaArray): JavaArray {
    if (levelInfo.length == 1)
      return new JavaArray("[Ljava/lang/String;").values(text);
    var result: JavaArray = new JavaArray("[Ljava/lang/String;").lengths(int(levelInfo.length / 2) + 1);
    var i: int;
    var endOffset: int;
    var beginOffset: int = 0;
    for (i = 0; i < result.length - 1; i++) {
      endOffset = levelInfo[i * 2 + 1];
      result[i] = Object(text).substring__II(beginOffset, endOffset);
      beginOffset = endOffset;
    }
    endOffset = Object(text).length__();
    result[i] = Object(text).substring__II(beginOffset, endOffset);
    return result;
  }
  public override function layout__(): void {
    var textFlow: TextFlow = TextFlow(this.getFlowFigure__());
    var offset: int = 0;
    var context_1: FlowContext = this.getContext__();
    var fragments: List = textFlow.getFragments__();
    var font: Font = textFlow.getFont__();
    var fragIndex: int = 0;
    var advance: int = 0;
    var fragment: TextFragmentBox;
    var levelInfo: JavaArray = (textFlow.getBidiInfo__() === null) ? new JavaArray("[I").values(-1) : textFlow.getBidiInfo__().levelInfo;
    var segment: String;
    var segments: JavaArray = this.getSegments__Ljava_lang_String_2_3I(textFlow.getText__(), levelInfo);
    var border: FlowBorder = null;
    if (textFlow.getBorder__() is FlowBorder)
      border = FlowBorder(textFlow.getBorder__());
    var lookahead: ParagraphTextLayout$SegmentLookahead = new ParagraphTextLayout$SegmentLookahead(this, segments, border === null ? 0 : border.getRightMargin__());
    var seg: int;
    if (border !== null) {
      fragment = this.getFragment__ILjava_util_List_2(fragIndex++, fragments);
      fragment.setBidiLevel__I(levelInfo[0]);
      fragment.setTruncated__Z(false);
      fragment.offset = fragment.length = -1;
      fragment.setWidth__I(border.getLeftMargin__() + border.getInsets__Lorg_eclipse_draw2d_IFigure_2(textFlow).left);
      if (context_1.getRemainingLineWidth__() < fragment.getWidth__() + lookahead.getWidth__())
        context_1.endLine__();
      context_1.addToCurrentLine__Lorg_eclipse_draw2d_text_FlowBox_2(fragment);
    }
    var flowUtilities: FlowUtilities = textFlow.getFlowUtilities__();
    for (seg = 0; seg < segments.length; seg++) {
      segment = segments[seg];
      lookahead.setIndex__I(seg);
      do {
        fragment = this.getFragment__ILjava_util_List_2(fragIndex++, fragments);
        fragment.offset = offset;
        fragment.setBidiLevel__I(levelInfo[seg * 2]);
        advance = flowUtilities.wrapFragmentInContext__Lorg_eclipse_draw2d_text_TextFragmentBox_2Ljava_lang_String_2Lorg_eclipse_draw2d_text_FlowContext_2Lorg_eclipse_draw2d_text_FlowUtilities$LookAhead_2Lorg_eclipse_swt_graphics_Font_2I(fragment, segment, context_1, lookahead, font, wrappingStyle);
        segment = Object(segment).substring__I(advance);
        offset += advance;
        if ((Object(segment).length__() > 0 || fragment.length < advance) || fragment.isTruncated__())
          context_1.endLine__();
      } while (Object(segment).length__() > 0 || (!fragment.isTruncated__() && fragment.length < advance));
    }
    if (border !== null) {
      fragment = this.getFragment__ILjava_util_List_2(fragIndex++, fragments);
      fragment.setBidiLevel__I(levelInfo[0]);
      fragment.setTruncated__Z(false);
      fragment.offset = fragment.length = -1;
      fragment.setWidth__I(border.getRightMargin__() + border.getInsets__Lorg_eclipse_draw2d_IFigure_2(textFlow).right);
      context_1.addToCurrentLine__Lorg_eclipse_draw2d_text_FlowBox_2(fragment);
    }
    while (fragIndex < fragments.size__())
      fragments.remove__I(fragments.size__() - 1);
    return;
  }
  public function ParagraphTextLayout(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is TextFlow) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is TextFlow && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        var superArgs: Array;
        superArgs = [args0[0]];
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        args0 = [args1[0]];
        superArgs = [args0[0]];
        break;
    }
    super(superArgs[0]);
    switch (id) {
      case 0:
        ParagraphTextLayout__Lorg_eclipse_draw2d_text_TextFlow_2(args0[0]);
        break;
      case 1:
        ParagraphTextLayout__Lorg_eclipse_draw2d_text_TextFlow_2(args0[0]);
        ParagraphTextLayout__Lorg_eclipse_draw2d_text_TextFlow_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const ParagraphTextLayout__Lorg_eclipse_draw2d_text_TextFlow_2 : int = 0;
  public static const ParagraphTextLayout__Lorg_eclipse_draw2d_text_TextFlow_2I : int = 1;
}
}
