package org.eclipse.draw2d.text {
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Character;
import java.util.List;
import java.lang.StringBuffer;
import java.lang.IllegalArgumentException;
import java.lang.Math__;
import java.lang.Integer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TextFlow extends InlineFlow {
  public static const ELLIPSIS: String = "...";
  private var bidiInfo: BidiInfo;
  private var selectionEnd: int = -1;
  private var text: String;
  public function TextFlow__(): Object {
    return this;
  }
  public function TextFlow__Ljava_lang_String_2(s: String): Object {
    text = s;
    return this;
  }
  public override function addLeadingWordRequirements___3I(width: JavaArray): Boolean {
    return this.addLeadingWordWidth__Ljava_lang_String_2_3I(this.getText__(), width);
  }
  public function addLeadingWordWidth__Ljava_lang_String_2_3I(text_1: String, width: JavaArray): Boolean {
    if (Object(text_1).length__() == 0)
      return false;
    if (Character.isWhitespace__C(Object(text_1).charAt__I(0)))
      return true;
    text_1 = String.fromCharCode(97) + text_1 + String.fromCharCode(97);
    FlowUtilities.LINE_BREAK.setText__Ljava_lang_String_2(text_1);
    var index: int = FlowUtilities.LINE_BREAK.next__() - 1;
    if (index == 0)
      return true;
    while (Character.isWhitespace__C(Object(text_1).charAt__I(index)))
      index--;
    var result: Boolean = index < Object(text_1).length__() - 1;
    if (index == Object(text_1).length__() - 1)
      index--;
    text_1 = Object(text_1).substring__II(1, index + 1);
    if (bidiInfo === null)
      width[0] += this.getTextUtilities__().getStringExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(text_1, this.getFont__()).width;
    else {
      var textLayout: org.eclipse.swt.graphics.TextLayout = FlowUtilities.getTextLayout__();
      textLayout.setFont__Lorg_eclipse_swt_graphics_Font_2(this.getFont__());
      textLayout.setText__Ljava_lang_String_2(text_1);
      width[0] += textLayout.getBounds__().width;
    }
    return result;
  }
  public override function contributeBidi__Lorg_eclipse_draw2d_text_BidiProcessor_2(proc: BidiProcessor): void {
    bidiInfo = null;
    proc.add__Lorg_eclipse_draw2d_text_FlowFigure_2Ljava_lang_String_2(this, this.getText__());
  }
  public override function createDefaultFlowLayout__(): FlowFigureLayout {
    return new ParagraphTextLayout(new Arguments(org.eclipse.draw2d.text.ParagraphTextLayout.ParagraphTextLayout__Lorg_eclipse_draw2d_text_TextFlow_2, [this]));
  }
  private function findNextLineOffset__Lorg_eclipse_draw2d_geometry_Point_2_3I(p: Point, trailing: JavaArray): int {
    if (this.getBounds__().bottom__() <= p.y)
      return -1;
    var closestBox: TextFragmentBox = null;
    var index: int = 0;
    var fragments_1: List = this.getFragmentsWithoutBorder__();
    for (var i: int = fragments_1.size__() - 1; i >= 0; i--) {
      var box: TextFragmentBox = TextFragmentBox(fragments_1.get__I(i));
      if (box.getBaseline__() - box.getLineRoot__().getAscent__() > p.y && (closestBox === null || box.getBaseline__() < closestBox.getBaseline__() || (box.getBaseline__() == closestBox.getBaseline__() && this.hDistanceBetween__Lorg_eclipse_draw2d_text_TextFragmentBox_2I(box, p.x) < this.hDistanceBetween__Lorg_eclipse_draw2d_text_TextFragmentBox_2I(closestBox, p.x)))) {
        closestBox = box;
        index = i;
      }
    }
    return this.findOffset__Lorg_eclipse_draw2d_geometry_Point_2_3ILorg_eclipse_draw2d_text_TextFragmentBox_2I(p, trailing, closestBox, index);
  }
  private function findOffset__Lorg_eclipse_draw2d_geometry_Point_2_3ILorg_eclipse_draw2d_text_TextFragmentBox_2I(p: Point, trailing: JavaArray, box: TextFragmentBox, boxIndex: int): int {
    if (box === null)
      return -1;
    var layout: org.eclipse.swt.graphics.TextLayout = FlowUtilities.getTextLayout__();
    layout.setFont__Lorg_eclipse_swt_graphics_Font_2(this.getFont__());
    layout.setText__Ljava_lang_String_2(this.getBidiSubstring__Lorg_eclipse_draw2d_text_TextFragmentBox_2I(box, boxIndex));
    var x: int = p.x - box.getX__();
    if (this.isMirrored__())
      x = box.getWidth__() - x;
    var layoutOffset: int = layout.getOffset__II_3I(x, p.y - box.getTextTop__(), trailing);
    return box.offset + layoutOffset - this.getBidiPrefixLength__Lorg_eclipse_draw2d_text_TextFragmentBox_2I(box, boxIndex);
  }
  private function findPreviousLineOffset__Lorg_eclipse_draw2d_geometry_Point_2_3I(p: Point, trailing: JavaArray): int {
    if (this.getBounds__().y > p.y)
      return -1;
    var closestBox: TextFragmentBox = null;
    var index: int = 0;
    var fragments_1: List = this.getFragmentsWithoutBorder__();
    for (var i: int = fragments_1.size__() - 1; i >= 0; i--) {
      var box: TextFragmentBox = TextFragmentBox(fragments_1.get__I(i));
      if (box.getBaseline__() + box.getLineRoot__().getDescent__() < p.y && (closestBox === null || box.getBaseline__() > closestBox.getBaseline__() || (box.getBaseline__() == closestBox.getBaseline__() && this.hDistanceBetween__Lorg_eclipse_draw2d_text_TextFragmentBox_2I(box, p.x) < this.hDistanceBetween__Lorg_eclipse_draw2d_text_TextFragmentBox_2I(closestBox, p.x)))) {
        closestBox = box;
        index = i;
      }
    }
    return this.findOffset__Lorg_eclipse_draw2d_geometry_Point_2_3ILorg_eclipse_draw2d_text_TextFragmentBox_2I(p, trailing, closestBox, index);
  }
  public function getAscent__(): int {
    return this.getTextUtilities__().getAscent__Lorg_eclipse_swt_graphics_Font_2(this.getFont__());
  }
  public function getBidiInfo__(): BidiInfo {
    return bidiInfo;
  }
  private function getBidiPrefixLength__Lorg_eclipse_draw2d_text_TextFragmentBox_2I(box: TextFragmentBox, index: int): int {
    if (box.getBidiLevel__() < 1)
      return 0;
    if (index > 0 || !bidiInfo.leadingJoiner)
      return 1;
    return 2;
  }
  public function getBidiSubstring__Lorg_eclipse_draw2d_text_TextFragmentBox_2I(box: TextFragmentBox, index: int): String {
    if (box.getBidiLevel__() < 1)
      return Object(this.getText__()).substring__II(box.offset, box.offset + box.length);
    var buffer: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__I, [box.length + 3]));
    buffer.append__C(box.isRightToLeft__() ? 8238 : 8237);
    if (index == 0 && bidiInfo.leadingJoiner)
      buffer.append__C(8205);
    buffer.append__Ljava_lang_String_2(Object(this.getText__()).substring__II(box.offset, box.offset + box.length));
    if (index == this.getFragmentsWithoutBorder__().size__() - 1 && bidiInfo.trailingJoiner)
      buffer.append__C(8205);
    return buffer.toString__();
  }
  public function getCaretPlacement__IZ(offset: int, trailing: Boolean): CaretInfo {
    if (offset < 0 || offset > Object(this.getText__()).length__())
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["Offset: " + offset + " is invalid"]));
    if (offset == Object(this.getText__()).length__())
      trailing = false;
    var fragments_1: List = this.getFragmentsWithoutBorder__();
    var i: int = fragments_1.size__();
    var box: TextFragmentBox;
    do
      box = TextFragmentBox(fragments_1.get__I(--i));
    while (offset < box.offset && i > 0);
    if (trailing && box.offset + box.length <= offset) {
      box = TextFragmentBox(fragments_1.get__I(++i));
      offset = box.offset;
      trailing = false;
    }
    var where: Point = this.getPointInBox__Lorg_eclipse_draw2d_text_TextFragmentBox_2IIZ(box, offset, i, trailing);
    var info: CaretInfo = new CaretInfo(new Arguments(org.eclipse.draw2d.text.CaretInfo.CaretInfo__IIIIII, [where.x, where.y, box.getAscent__(), box.getDescent__(), box.getLineRoot__().getAscent__(), box.getLineRoot__().getDescent__()]));
    this.translateToAbsolute__Lorg_eclipse_draw2d_geometry_Translatable_2(info);
    return info;
  }
  public function getPointInBox__Lorg_eclipse_draw2d_text_TextFragmentBox_2IIZ(box: TextFragmentBox, offset: int, index: int, trailing: Boolean): Point {
    offset -= box.offset;
    offset = Math__.min__II(box.length, offset);
    var result: Point = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [0, box.getTextTop__()]));
    if (bidiInfo === null) {
      if (trailing && offset < box.length)
        offset++;
      var substring: String = Object(this.getText__()).substring__II(box.offset, box.offset + offset);
      result.x = this.getTextUtilities__().getStringExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(substring, this.getFont__()).width;
    } else {
      var layout: org.eclipse.swt.graphics.TextLayout = FlowUtilities.getTextLayout__();
      layout.setFont__Lorg_eclipse_swt_graphics_Font_2(this.getFont__());
      var fragString: String = this.getBidiSubstring__Lorg_eclipse_draw2d_text_TextFragmentBox_2I(box, index);
      layout.setText__Ljava_lang_String_2(fragString);
      offset += this.getBidiPrefixLength__Lorg_eclipse_draw2d_text_TextFragmentBox_2I(box, index);
      result.x = layout.getLocation__IZ(offset, trailing).x;
      if (this.isMirrored__())
        result.x = box.width - result.x;
    }
    result.x += box.getX__();
    return result;
  }
  public function getDescent__(): int {
    return this.getTextUtilities__().getDescent__Lorg_eclipse_swt_graphics_Font_2(this.getFont__());
  }
  public function getFirstOffsetForLine__I(baseline: int): int {
    var box: TextFragmentBox;
    var fragments_1: List = this.getFragmentsWithoutBorder__();
    for (var i: int = 0; i < fragments_1.size__(); i++) {
      box = TextFragmentBox(fragments_1.get__I(i));
      if (baseline == box.getBaseline__())
        return box.offset;
    }
    return -1;
  }
  public function getFragmentsWithoutBorder__(): List {
    var fragments_1: List = this.getFragments__();
    if (this.getBorder__() !== null)
      fragments_1 = fragments_1.subList__II(1, fragments_1.size__() - 1);
    return fragments_1;
  }
  public function getLastOffsetForLine__I(baseline: int): int {
    var box: TextFragmentBox;
    var fragments_1: List = this.getFragmentsWithoutBorder__();
    for (var i: int = fragments_1.size__() - 1; i >= 0; i--) {
      box = TextFragmentBox(fragments_1.get__I(i));
      if (baseline == box.getBaseline__())
        return box.offset + box.length - 1;
    }
    return -1;
  }
  public function getNextOffset__Lorg_eclipse_draw2d_geometry_Point_2Z_3I(p: Point, down: Boolean, trailing: JavaArray): int {
    return down ? this.findNextLineOffset__Lorg_eclipse_draw2d_geometry_Point_2_3I(p, trailing) : this.findPreviousLineOffset__Lorg_eclipse_draw2d_geometry_Point_2_3I(p, trailing);
  }
  public function getNextVisibleOffset__I(offset: int): int {
    var box: TextFragmentBox;
    var fragments_1: List = this.getFragmentsWithoutBorder__();
    for (var i: int = 0; i < fragments_1.size__(); i++) {
      box = TextFragmentBox(fragments_1.get__I(i));
      if (box.offset + box.length <= offset)
        continue;
      return Math__.max__II(box.offset, offset + 1);
    }
    return -1;
  }
  public function getOffset__Lorg_eclipse_draw2d_geometry_Point_2_3ILorg_eclipse_draw2d_geometry_Dimension_2(p: Point, trailing: JavaArray, proximity: Dimension): int {
    if (proximity === null)
      proximity = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [2147483647, 2147483647]));
    var closestBox: TextFragmentBox = null;
    var index: int = 0;
    var dy: int;
    var dx: int;
    var i: int = 0;
    var size: int = fragments.size__();
    if (this.getBorder__() is FlowBorder) {
      i++;
      size--;
    }
    for (; i < size; i++) {
      var box: TextFragmentBox = TextFragmentBox(fragments.get__I(i));
      dy = this.vDistanceBetween__Lorg_eclipse_draw2d_text_TextFragmentBox_2I(box, p.y);
      if (dy > proximity.height)
        continue;
      dx = this.hDistanceBetween__Lorg_eclipse_draw2d_text_TextFragmentBox_2I(box, p.x);
      if (dy == proximity.height && dx >= proximity.width)
        continue;
      proximity.height = dy;
      proximity.width = dx;
      closestBox = box;
      index = i;
    }
    return this.findOffset__Lorg_eclipse_draw2d_geometry_Point_2_3ILorg_eclipse_draw2d_text_TextFragmentBox_2I(p, trailing, closestBox, index);
  }
  public function getPreviousVisibleOffset__I(offset: int): int {
    var box: TextFragmentBox;
    if (offset == -1)
      offset = 2147483647;
    var fragments_1: List = this.getFragmentsWithoutBorder__();
    for (var i: int = fragments_1.size__() - 1; i >= 0; i--) {
      box = TextFragmentBox(fragments_1.get__I(i));
      if (box.offset >= offset)
        continue;
      return Math__.min__II(box.offset + box.length, offset - 1);
    }
    return -1;
  }
  public function getText__(): String {
    return text;
  }
  public function getVisibleAscent__(): int {
    if (this.getBorder__() is FlowBorder) {
      var border_1: FlowBorder = FlowBorder(this.getBorder__());
      return border_1.getInsets__Lorg_eclipse_draw2d_IFigure_2(this).top + this.getAscent__();
    }
    return this.getAscent__();
  }
  public function getVisibleDescent__(): int {
    if (this.getBorder__() is FlowBorder) {
      var border_1: FlowBorder = FlowBorder(this.getBorder__());
      return border_1.getInsets__Lorg_eclipse_draw2d_IFigure_2(this).bottom + this.getDescent__();
    }
    return this.getDescent__();
  }
  private function hDistanceBetween__Lorg_eclipse_draw2d_text_TextFragmentBox_2I(box: TextFragmentBox, x: int): int {
    if (x < box.getX__())
      return box.getX__() - x;
    return Math__.max__II(0, x - (box.getX__() + box.getWidth__()));
  }
  public function isTextTruncated__(): Boolean {
    for (var i: int = 0; i < fragments.size__(); i++) {
      if ((TextFragmentBox(fragments.get__I(i))).isTruncated__())
        return true;
    }
    return false;
  }
  public override function paintFigure__Lorg_eclipse_draw2d_Graphics_2(g: Graphics): void {
    var frag: TextFragmentBox;
    g.getClip__Lorg_eclipse_draw2d_geometry_Rectangle_2(Rectangle.SINGLETON);
    var yStart: int = Rectangle.SINGLETON.y;
    var yEnd: int = Rectangle.SINGLETON.bottom__();
    for (var i: int = 0; i < fragments.size__(); i++) {
      frag = TextFragmentBox(fragments.get__I(i));
      if (frag.offset == -1)
        continue;
      if (yStart > frag.getLineRoot__().getVisibleBottom__() + 1)
        continue;
      if (yEnd < frag.getLineRoot__().getVisibleTop__())
        break;
      var draw: String = this.getBidiSubstring__Lorg_eclipse_draw2d_text_TextFragmentBox_2I(frag, i);
      if (frag.isTruncated__())
        draw += "...";
      if (!this.isEnabled__()) {
        var fgColor_1: Color = g.getForegroundColor__();
        g.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.buttonLightest);
        this.paintText__Lorg_eclipse_draw2d_Graphics_2Ljava_lang_String_2III(g, draw, frag.getX__() + 1, frag.getBaseline__() - this.getAscent__() + 1, frag.getBidiLevel__());
        g.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.buttonDarker);
        this.paintText__Lorg_eclipse_draw2d_Graphics_2Ljava_lang_String_2III(g, draw, frag.getX__(), frag.getBaseline__() - this.getAscent__(), frag.getBidiLevel__());
        g.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(fgColor_1);
      } else {
        this.paintText__Lorg_eclipse_draw2d_Graphics_2Ljava_lang_String_2III(g, draw, frag.getX__(), frag.getBaseline__() - this.getAscent__(), frag.getBidiLevel__());
      }
    }
    return;
  }
  public override function paintSelection__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    if (selectionStart == -1)
      return;
    graphics.setXORMode__Z(true);
    graphics.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.white);
    var frag: TextFragmentBox;
    for (var i: int = 0; i < fragments.size__(); i++) {
      frag = TextFragmentBox(fragments.get__I(i));
      if (frag.offset + frag.length <= selectionStart)
        continue;
      if (frag.offset > selectionEnd)
        return;
      if (selectionStart <= frag.offset && selectionEnd >= frag.offset + frag.length) {
        var y: int = frag.getLineRoot__().getVisibleTop__();
        var height: int = frag.getLineRoot__().getVisibleBottom__() - y;
        graphics.fillRectangle__IIII(frag.getX__(), y, frag.getWidth__(), height);
      } else if (selectionEnd > frag.offset && selectionStart < frag.offset + frag.length) {
        var p1: Point = this.getPointInBox__Lorg_eclipse_draw2d_text_TextFragmentBox_2IIZ(frag, Math__.max__II(frag.offset, selectionStart), i, false);
        var p2: Point = this.getPointInBox__Lorg_eclipse_draw2d_text_TextFragmentBox_2IIZ(frag, Math__.min__II(frag.offset + frag.length, selectionEnd) - 1, i, true);
        var rect: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2, [p1, p2]));
        rect.width--;
        rect.y = frag.getLineRoot__().getVisibleTop__();
        rect.height = frag.getLineRoot__().getVisibleBottom__() - rect.y;
        graphics.fillRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
      }
    }
    return;
  }
  public function paintText__Lorg_eclipse_draw2d_Graphics_2Ljava_lang_String_2III(g: Graphics, draw: String, x: int, y: int, bidiLevel: int): void {
    if (bidiLevel == -1) {
      g.drawString__Ljava_lang_String_2II(draw, x, y);
    } else {
      var tl: org.eclipse.swt.graphics.TextLayout = FlowUtilities.getTextLayout__();
      if (this.isMirrored__())
        tl.setOrientation__I(67108864);
      tl.setFont__Lorg_eclipse_swt_graphics_Font_2(g.getFont__());
      tl.setText__Ljava_lang_String_2(draw);
      g.drawTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2II(tl, x, y);
    }
    return;
  }
  public override function setBidiInfo__Lorg_eclipse_draw2d_text_BidiInfo_2(info: BidiInfo): void {
    this.bidiInfo = info;
    return;
  }
  public override function setSelection__II(start: int, end: int): void {
    var repaint: Boolean = false;
    if (selectionStart == start) {
      if (selectionEnd == end)
        return;
      repaint = true;
    } else
      repaint = selectionStart != selectionEnd || start != end;
    selectionStart = start;
    selectionEnd = end;
    if (repaint)
      this.repaint__();
    return;
  }
  public function setText__Ljava_lang_String_2(s: String): void {
    if (s !== null && !Object(s).equals__Ljava_lang_Object_2(text)) {
      text = s;
      this.revalidateBidi__Lorg_eclipse_draw2d_IFigure_2(this);
      this.repaint__();
    }
    return;
  }
  public function toString__(): String {
    return text;
  }
  private function vDistanceBetween__Lorg_eclipse_draw2d_text_TextFragmentBox_2I(box: TextFragmentBox, y: int): int {
    var top: int = box.getBaseline__() - box.getLineRoot__().getAscent__();
    if (y < top)
      return top - y;
    return Math__.max__II(0, y - (box.getBaseline__() + box.getLineRoot__().getDescent__()));
  }
  public function getFlowUtilities__(): FlowUtilities {
    return FlowUtilities.INSTANCE;
  }
  public function getTextUtilities__(): TextUtilities {
    return TextUtilities.INSTANCE;
  }
  public function TextFlow(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        args1 = [new String()];
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        TextFlow__Ljava_lang_String_2(args1[0]);
        TextFlow__();
        break;
      case 1:
        TextFlow__Ljava_lang_String_2(args1[0]);
        break;
    }
  }
  public static const TextFlow__ : int = 0;
  public static const TextFlow__Ljava_lang_String_2 : int = 1;
}
}
