package org.eclipse.draw2d.text {
dynamic public class TextFragmentBox extends ContentBox {
  public var length: int;
  public var offset: int;
  private var textflow: TextFlow;
  private var truncated: Boolean;
  public function TextFragmentBox(textflow: TextFlow) {
    this.textflow = textflow;
    return;
  }
  public override function containsPoint__II(x_1: int, y: int): Boolean {
    return x_1 >= this.getX__() && x_1 < this.getX__() + this.getWidth__() && y >= this.getBaseline__() - this.getAscentWithBorder__() && y <= this.getBaseline__() + this.getDescentWithBorder__();
  }
  public override function getAscent__(): int {
    return textflow.getAscent__();
  }
  public override function getAscentWithBorder__(): int {
    return textflow.getAscent__() + FlowUtilities.getBorderAscent__Lorg_eclipse_draw2d_text_InlineFlow_2(textflow);
  }
  public override function getDescent__(): int {
    return textflow.getDescent__();
  }
  public override function getDescentWithBorder__(): int {
    return textflow.getDescent__() + FlowUtilities.getBorderDescent__Lorg_eclipse_draw2d_text_InlineFlow_2(textflow);
  }
  public override function getOuterAscent__(): int {
    return textflow.getAscent__() + FlowUtilities.getBorderAscentWithMargin__Lorg_eclipse_draw2d_text_InlineFlow_2(textflow);
  }
  public override function getOuterDescent__(): int {
    return textflow.getDescent__() + FlowUtilities.getBorderDescentWithMargin__Lorg_eclipse_draw2d_text_InlineFlow_2(textflow);
  }
  public function getTextTop__(): int {
    return this.getBaseline__() - this.getAscent__();
  }
  public function isRightToLeft__(): Boolean {
    return this.getBidiLevel__() % 2 == 1;
  }
  public function isTruncated__(): Boolean {
    return truncated;
  }
  public function setTruncated__Z(value: Boolean): void {
    this.truncated = value;
  }
  public function toString__(): String {
    return "[" + offset + ", " + (offset + length) + ") = \"" + Object(textflow.getText__()).substring__II(offset, offset + length) + String.fromCharCode(34);
  }
}
}
