package org.eclipse.draw2d.widgets {
import org.eclipse.swt.graphics.Image;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Arguments;
dynamic public class ImageBorder extends AbstractBorder {
  private var imgInsets: Insets;
  private var image: Image;
  private var imageSize: Dimension;
  public function ImageBorder(image: Image) {
    this.setImage__Lorg_eclipse_swt_graphics_Image_2(image);
    return;
  }
  public override function getInsets__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): Insets {
    return imgInsets;
  }
  public function getImage__(): Image {
    return image;
  }
  public override function getPreferredSize__Lorg_eclipse_draw2d_IFigure_2(f: IFigure): Dimension {
    return imageSize;
  }
  public override function paint__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Insets_2(figure: IFigure, graphics: Graphics, insets: Insets): void {
    if (image === null)
      return;
    var rect: Rectangle = AbstractBorder.getPaintRectangle__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_geometry_Insets_2(figure, insets);
    var x: int = rect.x;
    var y: int = rect.y + int((rect.height - imageSize.height) / 2);
    graphics.drawImage__Lorg_eclipse_swt_graphics_Image_2II(this.getImage__(), x, y);
  }
  public function setImage__Lorg_eclipse_swt_graphics_Image_2(img: Image): void {
    image = img;
    imageSize = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__Lorg_eclipse_swt_graphics_Image_2, [image]));
    imgInsets = new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__, []));
    imgInsets.left = imageSize.width;
  }
}
}
