package org.eclipse.draw2d.widgets {
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.ACC;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import java.lang.Arguments;
dynamic public class MultiLineLabel extends FigureCanvas {
  private var textFlow: TextFlow;
  public static var MARGIN: Border = new MarginBorder(new Arguments(org.eclipse.draw2d.MarginBorder.MarginBorder__I, [2]));
  private var image: Image;
  public function MultiLineLabel(parent: Composite) {
    super(new Arguments(org.eclipse.draw2d.FigureCanvas.FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2, [parent]));
    this.setViewport__Lorg_eclipse_draw2d_Viewport_2(new MultiLineLabel$FocusableViewport(this));
    var page: FlowPage = new FlowPage();
    textFlow = new TextFlow(new Arguments(org.eclipse.draw2d.text.TextFlow.TextFlow__, []));
    page.add__Lorg_eclipse_draw2d_IFigure_2(textFlow);
    this.setContents__Lorg_eclipse_draw2d_IFigure_2(page);
    this.getViewport__().setContentsTracksWidth__Z(true);
    this.addAccessibility__();
    return;
  }
  private function addAccessibility__(): void {
    this.getAccessible__().addAccessibleControlListener__Lorg_eclipse_swt_accessibility_AccessibleControlListener_2(new org.eclipse.draw2d.widgets.MultiLineLabel$1(this));
    this.getAccessible__().addAccessibleListener__Lorg_eclipse_swt_accessibility_AccessibleListener_2(new org.eclipse.draw2d.widgets.MultiLineLabel$2(this));
    this.addKeyListener__Lorg_eclipse_swt_events_KeyListener_2(new org.eclipse.draw2d.widgets.MultiLineLabel$3(this));
    return;
  }
  public override function setEnabled__Z(enabled: Boolean): void {
    super.setEnabled__Z(enabled);
    textFlow.setEnabled__Z(this.getEnabled__());
    return;
  }
  public function getImage__(): Image {
    return image;
  }
  public function getText__(): String {
    return textFlow.getText__();
  }
  public override function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
    super.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
    textFlow.revalidate__();
  }
  public function setImage__Lorg_eclipse_swt_graphics_Image_2(image_1: Image): void {
    this.image = image_1;
    if (image_1 !== null)
      this.setBorder__Lorg_eclipse_draw2d_Border_2(new ImageBorder(image_1));
    else
      this.setBorder__Lorg_eclipse_draw2d_Border_2(null);
  }
  public function setText__Ljava_lang_String_2(text: String): void {
    textFlow.setText__Ljava_lang_String_2(text);
  }
}
}
