package org.eclipse.swt.e4.examples.draw2d {
import java.util.*;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.*;
import org.eclipse.draw2d.geometry.Point;
import java.util.Map;
import java.util.Iterator;
import java.util.HashMap;
import java.lang.System;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Math__;
import java.util.ArrayList;
import java.lang.Arguments;
dynamic public class Animation {
  public static const DURATION: Number = 210;
  public static var current: Number = 0;
  public static var progress: Number = 0;
  public static var start: Number = -1;
  public static var finish: Number = 0;
  public static var viewport: Viewport;
  public static var trackMe: IFigure;
  public static var showMe: IFigure;
  public static var trackLocation: Point;
  public static var PLAYBACK: Boolean;
  public static var RECORDING: Boolean;
  public static var initialStates: Map;
  public static var finalStates: Map;
  public static function end__(): void {
    var iter: Iterator = Iterator(initialStates.keySet__().iterator__());
    while (iter.hasNext__())
      (IFigure(iter.next__())).revalidate__();
    initialStates = null;
    finalStates = null;
    PLAYBACK = false;
    trackMe = null;
    showMe = null;
    viewport = null;
    return;
  }
  public static function mark__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    trackMe = figure;
    trackLocation = trackMe.getBounds__().getLocation__();
    while (!(figure is Viewport))
      figure = figure.getParent__();
    viewport = Viewport(figure);
    initialStates = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
    finalStates = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
    start = System.currentTimeMillis__();
    finish = start + 210;
    current = start + 20;
    return;
  }
  public static function captureLayout__Lorg_eclipse_draw2d_IFigure_2(root: IFigure): void {
    RECORDING = true;
    while (root.getParent__() !== null)
      root = root.getParent__();
    root.validate__();
    var iter: Iterator = Iterator(initialStates.keySet__().iterator__());
    while (iter.hasNext__())
      recordFinalStates__Lorg_eclipse_draw2d_IFigure_2(IFigure(iter.next__()));
    RECORDING = false;
    PLAYBACK = true;
    return;
  }
  public static function playbackState__Lorg_eclipse_draw2d_IFigure_2(container: IFigure): Boolean {
    if (!PLAYBACK)
      return false;
    var initial: List = List(initialStates.get__Ljava_lang_Object_2(container));
    if (initial === null) {
      System.out.println__Ljava_lang_String_2("Error playing back state");
      return false;
    }
    var target: List = List(finalStates.get__Ljava_lang_Object_2(container));
    var children: List = container.getChildren__();
    var rect1: Rectangle;
    var rect2: Rectangle;
    for (var i: int = 0; i < children.size__(); i++) {
      var child: IFigure = IFigure(children.get__I(i));
      rect1 = Rectangle(initial.get__I(i));
      rect2 = Rectangle(target.get__I(i));
      child.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [int(Math__.round__D(progress * rect2.x + (1 - progress) * rect1.x)), int(Math__.round__D(progress * rect2.y + (1 - progress) * rect1.y)), int(Math__.round__D(progress * rect2.width + (1 - progress) * rect1.width)), int(Math__.round__D(progress * rect2.height + (1 - progress) * rect1.height))])));
    }
    return true;
  }
  public static function recordFinalStates__Lorg_eclipse_draw2d_IFigure_2(container: IFigure): void {
    var list: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    finalStates.put__Ljava_lang_Object_2Ljava_lang_Object_2(container, list);
    var children: List = container.getChildren__();
    list.clear__();
    for (var i: int = 0; i < children.size__(); i++)
      list.add__Ljava_lang_Object_2((IFigure(children.get__I(i))).getBounds__().getCopy__());
  }
  public static function recordInitialState__Lorg_eclipse_draw2d_IFigure_2(container: IFigure): void {
    if (!RECORDING)
      return;
    var list: List = List(initialStates.get__Ljava_lang_Object_2(container));
    if (list !== null)
      return;
    initialStates.put__Ljava_lang_Object_2Ljava_lang_Object_2(container, list = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, [])));
    var children: List = container.getChildren__();
    list.clear__();
    for (var i: int = 0; i < children.size__(); i++)
      list.add__Ljava_lang_Object_2((IFigure(children.get__I(i))).getBounds__().getCopy__());
  }
  public static function swap__(): void {
    var temp: Map = finalStates;
    finalStates = initialStates;
    initialStates = temp;
  }
  public static function step__(): Boolean {
    current = System.currentTimeMillis__() + 30;
    progress = Number((current - start)) / (finish - start);
    progress = Math__.min__DD(progress, 0.999);
    var iter: Iterator = Iterator(initialStates.keySet__().iterator__());
    while (iter.hasNext__())
      (IFigure(iter.next__())).revalidate__();
    viewport.validate__();
    var loc: Point = viewport.getViewLocation__();
    loc.translate__Lorg_eclipse_draw2d_geometry_Dimension_2(trackMe.getBounds__().getLocation__().getDifference__Lorg_eclipse_draw2d_geometry_Point_2(trackLocation));
    viewport.setViewLocation__Lorg_eclipse_draw2d_geometry_Point_2(loc);
    trackLocation = trackMe.getBounds__().getLocation__();
    return current < finish;
  }
}
}
