package org.eclipse.swt.e4.examples.draw2d {
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Transposer;
import java.util.List;
import java.lang.JavaArray;
dynamic public class BranchLayout extends AbstractLayout {
  private var transposer: Transposer;
  internal var branch: TreeBranch;
  internal var cachedContourLeft: JavaArray;
  internal var cachedContourRight: JavaArray;
  internal var depth: int = -1;
  public var horizontal: Boolean = true;
  internal var preferredRowHeights: JavaArray;
  internal var rowHeight: int;
  public function BranchLayout(branch: TreeBranch) {
    this.branch = branch;
    return;
  }
  public function calculateDepth__(): void { } // abstract
  public function getContourLeft__(): JavaArray {
    if (cachedContourLeft === null)
      this.updateContours__();
    return cachedContourLeft;
  }
  public function getContourRight__(): JavaArray {
    if (cachedContourRight === null)
      this.updateContours__();
    return cachedContourRight;
  }
  public function getDepth__(): int {
    if (!branch.isExpanded__())
      return 1;
    if (depth == -1)
      this.calculateDepth__();
    return depth;
  }
  public function getPreferredRowHeights__(): JavaArray {
    if (preferredRowHeights === null)
      this.updateRowHeights__();
    return preferredRowHeights;
  }
  public function getSubtrees__(): List {
    return branch.getContentsPane__().getChildren__();
  }
  public function getTransposer__(): Transposer {
    if (transposer === null)
      transposer = branch.getRoot__().getTransposer__();
    return transposer;
  }
  public function getMajorSpacing__(): int {
    return branch.getRoot__().getMajorSpacing__();
  }
  public override function invalidate__(): void {
    preferredRowHeights = null;
    cachedContourLeft = null;
    cachedContourRight = null;
    depth = -1;
    super.invalidate__();
  }
  public function isHorizontal__(): Boolean {
    return horizontal;
  }
  public function paintLines__Lorg_eclipse_draw2d_Graphics_2(g: Graphics): void { } // abstract
  public function setHorizontal__Z(value: Boolean): void {
    horizontal = value;
  }
  public function setRowHeights___3II(heights: JavaArray, offset: int): void {
    if (rowHeight != heights[offset]) {
      rowHeight = heights[offset];
      branch.revalidate__();
    }
    return;
  }
  public function updateContours__(): void { } // abstract
  public function updateRowHeights__(): void { } // abstract
}
}
