package org.eclipse.swt.e4.examples.draw2d {
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import java.util.List;
import java.lang.Math__;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class HangingLayout extends BranchLayout {
  function HangingLayout(branch: TreeBranch) {
    super(branch);
    return;
  }
  public override function calculateDepth__(): void {
    depth = 0;
    var subtrees: List = branch.contents.getChildren__();
    for (var i: int = 0; i < subtrees.size__(); i++)
      depth += (TreeBranch(subtrees.get__I(i))).getDepth__();
    depth++;
    return;
  }
  public override function setRowHeights___3II(heights: JavaArray, offset: int): void {
    super.setRowHeights___3II(heights, offset);
    offset++;
    if (branch.isExpanded__()) {
      var subtrees: List = branch.contents.getChildren__();
      var subtree: TreeBranch;
      for (var i: int = 0; i < subtrees.size__(); i++) {
        subtree = TreeBranch(subtrees.get__I(i));
        subtree.setRowHeights___3II(heights, offset);
        offset += subtree.getDepth__();
      }
    }
    return;
  }
  public override function updateRowHeights__(): void {
    var transposer_1: Transposer = branch.getRoot__().getTransposer__();
    preferredRowHeights = new JavaArray("[I").lengths(this.getDepth__());
    preferredRowHeights[0] = transposer_1.t__Lorg_eclipse_draw2d_geometry_Dimension_2(branch.getNode__().getPreferredSize__()).height + this.getMajorSpacing__();
    if (!branch.isExpanded__())
      return;
    var subtrees: List = this.getSubtrees__();
    var subtree: TreeBranch;
    var offset: int = 1;
    for (var i: int = 0; i < subtrees.size__(); i++) {
      subtree = TreeBranch(subtrees.get__I(i));
      var rowHeights: JavaArray = subtree.getPreferredRowHeights__();
      for (var row: int = 0; row < rowHeights.length; row++)
        preferredRowHeights[row + offset] = rowHeights[row];
      offset += subtree.getDepth__();
    }
    return;
  }
  public function getGap__(): int {
    return branch.getRoot__().getMinorSpacing__();
  }
  public override function calculatePreferredSize__Lorg_eclipse_draw2d_IFigure_2II(container: IFigure, wHint: int, hHint: int): Dimension {
    var transposer_1: Transposer = branch.getRoot__().getTransposer__();
    var result: Dimension = transposer_1.t__Lorg_eclipse_draw2d_geometry_Dimension_2(branch.getNode__().getPreferredSize__().getCopy__());
    result.height = rowHeight;
    var pane: IFigure = branch.getContentsPane__();
    if (!pane.isVisible__() || pane.getChildren__().isEmpty__())
      return transposer_1.t__Lorg_eclipse_draw2d_geometry_Dimension_2(result);
    var d: Dimension = transposer_1.t__Lorg_eclipse_draw2d_geometry_Dimension_2(branch.getContentsPane__().getPreferredSize__());
    result.width = Math__.max__II(result.width, d.width + this.getGap__() * 2);
    result.height += d.height;
    return transposer_1.t__Lorg_eclipse_draw2d_geometry_Dimension_2(result);
  }
  public override function layout__Lorg_eclipse_draw2d_IFigure_2(f: IFigure): void {
    Animation.recordInitialState__Lorg_eclipse_draw2d_IFigure_2(f);
    if (Animation.playbackState__Lorg_eclipse_draw2d_IFigure_2(f))
      return;
    branch.getContentsPane__().validate__();
    var transposer_1: Transposer = this.getTransposer__();
    var clientArea: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, []));
    branch.getClientArea__Lorg_eclipse_draw2d_geometry_Rectangle_2(clientArea);
    clientArea = transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(clientArea);
    var nodeBounds: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, []));
    nodeBounds.setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(transposer_1.t__Lorg_eclipse_draw2d_geometry_Dimension_2(branch.getNode__().getPreferredSize__()));
    nodeBounds.height = rowHeight - this.getMajorSpacing__();
    nodeBounds.setLocation__II(clientArea.x, clientArea.y);
    branch.getNode__().setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(nodeBounds));
    var contents: IFigure = branch.getContentsPane__();
    var contentsBounds: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2, [clientArea.getLocation__().translate__II(this.getGap__() * 2, rowHeight), transposer_1.t__Lorg_eclipse_draw2d_geometry_Dimension_2(contents.getPreferredSize__())]));
    contents.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(contentsBounds));
  }
  public override function paintLines__Lorg_eclipse_draw2d_Graphics_2(g: Graphics): void {
    var gap: int = this.getGap__();
    if (this.getTransposer__().isEnabled__()) {
      var node: IFigure = branch.getNode__();
      var contents: IFigure = branch.getContentsPane__();
      var x: int = node.getBounds__().right__();
      var y: int = node.getBounds__().y + gap;
      var children: List = contents.getChildren__();
      if (children.size__() == 0)
        return;
      var right: int = x;
      for (var i: int = 0; i < children.size__(); i++) {
        var pt: Point = (TreeBranch(children.get__I(i))).getNodeBounds__().getTop__();
        g.drawLine__IIII(pt.x, y, pt.x, pt.y);
        right = Math__.max__II(right, pt.x);
      }
      g.drawLine__IIII(x, y, right, y);
    } else {
      var node_1: IFigure = branch.getNode__();
      var contents_1: IFigure = branch.getContentsPane__();
      var x_1: int = node_1.getBounds__().x + gap;
      var y_1: int = node_1.getBounds__().bottom__();
      var children_1: List = contents_1.getChildren__();
      if (children_1.size__() == 0)
        return;
      var bottom: int = y_1;
      for (var i_1: int = 0; i_1 < children_1.size__(); i_1++) {
        var pt_1: Point = (TreeBranch(children_1.get__I(i_1))).getNodeBounds__().getLeft__();
        g.drawLine__IIII(x_1, pt_1.y, pt_1.x, pt_1.y);
        bottom = Math__.max__II(bottom, pt_1.y);
      }
      g.drawLine__IIII(x_1, y_1, x_1, bottom);
    }
    return;
  }
  public override function updateContours__(): void {
    var transposer_1: Transposer = this.getTransposer__();
    branch.validate__();
    cachedContourLeft = new JavaArray("[I").lengths(this.getDepth__());
    cachedContourRight = new JavaArray("[I").lengths(this.getDepth__());
    var clientArea: Rectangle = transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(branch.getClientArea__Lorg_eclipse_draw2d_geometry_Rectangle_2(Rectangle.SINGLETON));
    var nodeBounds: Rectangle = transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(branch.getNodeBounds__());
    var rightEdge: int = clientArea.right__();
    cachedContourLeft[0] = nodeBounds.x - clientArea.x;
    cachedContourRight[0] = rightEdge - nodeBounds.right__();
    if (!branch.isExpanded__())
      return;
    var subtrees: List = branch.contents.getChildren__();
    var subtree: TreeBranch;
    var leftSide: int = this.getGap__();
    for (var i: int = 1; i < this.getDepth__(); i++)
      cachedContourLeft[i] = leftSide;
    var rightMargin: int;
    var offset: int = 1;
    for (var i_1: int = 0; i_1 < subtrees.size__(); i_1++) {
      subtree = TreeBranch(subtrees.get__I(i_1));
      rightMargin = rightEdge - transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(subtree.getBounds__()).right__();
      var rightContour: JavaArray = subtree.getContourRight__();
      for (var j: int = 0; j < rightContour.length; j++)
        cachedContourRight[j + offset] = rightContour[j] + rightMargin;
      offset += subtree.getDepth__();
    }
    return;
  }
}
}
