package org.eclipse.swt.e4.examples.draw2d {
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import java.util.List;
import java.lang.Math__;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class NormalLayout extends BranchLayout {
  function NormalLayout(branch: TreeBranch) {
    super(branch);
    return;
  }
  public override function calculateDepth__(): void {
    depth = 0;
    var subtrees: List = this.getSubtrees__();
    for (var i: int = 0; i < subtrees.size__(); i++)
      depth = Math__.max__II(depth, (TreeBranch(subtrees.get__I(i))).getDepth__());
    depth++;
    return;
  }
  public override function calculatePreferredSize__Lorg_eclipse_draw2d_IFigure_2II(container: IFigure, wHint: int, hHint: int): Dimension {
    var union: Rectangle = branch.getNodeBounds__().getCopy__();
    union.union__Lorg_eclipse_draw2d_geometry_Rectangle_2(branch.getContentsPane__().getBounds__());
    return union.getSize__();
  }
  public override function layout__Lorg_eclipse_draw2d_IFigure_2(f: IFigure): void {
    Animation.recordInitialState__Lorg_eclipse_draw2d_IFigure_2(f);
    if (Animation.playbackState__Lorg_eclipse_draw2d_IFigure_2(f))
      return;
    var transposer_1: Transposer = this.getTransposer__();
    var contents: IFigure = branch.getContentsPane__();
    var node: IFigure = branch.getNode__();
    contents.validate__();
    var branchBounds: Rectangle = transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(branch.getBounds__());
    var topLeft: Point = branchBounds.getTopLeft__();
    var nodeLocation: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2, [topLeft, transposer_1.t__Lorg_eclipse_draw2d_geometry_Dimension_2(node.getPreferredSize__())]));
    nodeLocation.height = rowHeight - this.getMajorSpacing__();
    if (!contents.isVisible__() || contents.getChildren__().isEmpty__()) {
      nodeLocation.x += int((branchBounds.width - nodeLocation.width) / 2);
      node.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(nodeLocation));
      contents.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(nodeLocation.getTranslated__II(0, rowHeight).setSize__II(0, 0)));
      return;
    }
    var contentsLocation: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2, [topLeft, transposer_1.t__Lorg_eclipse_draw2d_geometry_Dimension_2(contents.getPreferredSize__())]));
    contents.setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(contents.getPreferredSize__());
    contentsLocation.y += rowHeight;
    var firstChild: TreeBranch = TreeBranch(contents.getChildren__().get__I(0));
    var lastChild: TreeBranch = TreeBranch(contents.getChildren__().get__I(contents.getChildren__().size__() - 1));
    var leftInset: int = firstChild.getContourLeft__()[0] + transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(firstChild.getBounds__()).x - transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(contents.getBounds__()).x;
    var rightInset: int = lastChild.getContourRight__()[0] - transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(lastChild.getBounds__()).right__() + transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(contents.getBounds__()).right__();
    rightInset = Math__.max__II(rightInset, 0);
    leftInset = Math__.max__II(leftInset, 0);
    var childrenSpan: int = contentsLocation.width - leftInset - rightInset;
    switch (branch.getAlignment__()) {
      case 2 :
        leftInset += int((childrenSpan - nodeLocation.width) / 2);
    }
    if (leftInset > 0)
      nodeLocation.x += leftInset;
    else
      contentsLocation.x -= leftInset;
    var adjust: int = branchBounds.width - Rectangle.SINGLETON.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(contentsLocation).union__Lorg_eclipse_draw2d_geometry_Rectangle_2(nodeLocation).width;
    adjust /= 2;
    nodeLocation.x += adjust;
    contentsLocation.x += adjust;
    node.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(nodeLocation));
    contents.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(contentsLocation));
    return;
  }
  public function mergeContour___3I_3III(destination: JavaArray, source: JavaArray, startdepth: int, offset: int): void {
    for (var i: int = startdepth; i < source.length; i++)
      destination[i + 1] = source[i] + offset;
    return;
  }
  public override function paintLines__Lorg_eclipse_draw2d_Graphics_2(g: Graphics): void {
    if (this.getTransposer__().isEnabled__()) {
      var node: IFigure = branch.getNode__();
      var left: int = node.getBounds__().right__();
      var right: int = branch.getContentsPane__().getBounds__().x - 1;
      var yMid: int = node.getBounds__().getCenter__().y;
      var xMid: int = int((left + right) / 2);
      var children: List = this.getSubtrees__();
      if (children.size__() == 0)
        return;
      g.drawLine__IIII(left, yMid, xMid, yMid);
      var yMin: int = yMid;
      var yMax: int = yMid;
      for (var i: int = 0; i < children.size__(); i++) {
        var y: int = (TreeBranch(children.get__I(i))).getNodeBounds__().getCenter__().y;
        g.drawLine__IIII(xMid, y, right, y);
        yMin = Math__.min__II(yMin, y);
        yMax = Math__.max__II(yMax, y);
      }
      g.drawLine__IIII(xMid, yMin, xMid, yMax);
    } else {
      var node_1: IFigure = branch.getNode__();
      var xMid_1: int = node_1.getBounds__().getCenter__().x;
      var top: int = node_1.getBounds__().bottom__();
      var bottom: int = branch.getContentsPane__().getBounds__().y - 1;
      var yMid_1: int = int((top + bottom) / 2);
      var children_1: List = this.getSubtrees__();
      if (children_1.size__() == 0)
        return;
      g.drawLine__IIII(xMid_1, top, xMid_1, yMid_1);
      var xMin: int = xMid_1;
      var xMax: int = xMid_1;
      for (var i_1: int = 0; i_1 < children_1.size__(); i_1++) {
        var x: int = (TreeBranch(children_1.get__I(i_1))).getNodeBounds__().getCenter__().x;
        g.drawLine__IIII(x, yMid_1, x, bottom);
        xMin = Math__.min__II(xMin, x);
        xMax = Math__.max__II(xMax, x);
      }
      g.drawLine__IIII(xMin, yMid_1, xMax, yMid_1);
    }
    return;
  }
  public override function updateContours__(): void {
    var transposer_1: Transposer = this.getTransposer__();
    branch.validate__();
    cachedContourLeft = new JavaArray("[I").lengths(this.getDepth__());
    cachedContourRight = new JavaArray("[I").lengths(this.getDepth__());
    var clientArea: Rectangle = transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(branch.getNodeBounds__().getUnion__Lorg_eclipse_draw2d_geometry_Rectangle_2(branch.contents.getBounds__()));
    var nodeBounds: Rectangle = transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(branch.getNodeBounds__());
    var contentsBounds: Rectangle = transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(branch.getContentsPane__().getBounds__());
    cachedContourLeft[0] = nodeBounds.x - clientArea.x;
    cachedContourRight[0] = clientArea.right__() - nodeBounds.right__();
    if (!branch.isExpanded__())
      return;
    var subtrees: List = this.getSubtrees__();
    var subtree: TreeBranch;
    var currentDepth: int = 0;
    for (var i: int = 0; i < subtrees.size__() && currentDepth < this.getDepth__(); i++) {
      subtree = TreeBranch(subtrees.get__I(i));
      if (subtree.getDepth__() > currentDepth) {
        var leftContour: JavaArray = subtree.getContourLeft__();
        var leftOffset: int = transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(subtree.getBounds__()).x - clientArea.x;
        this.mergeContour___3I_3III(cachedContourLeft, leftContour, currentDepth, leftOffset);
        currentDepth = subtree.getDepth__();
      }
    }
    currentDepth = 0;
    for (var i_1: int = subtrees.size__() - 1; i_1 >= 0 && currentDepth < this.getDepth__(); i_1--) {
      subtree = TreeBranch(subtrees.get__I(i_1));
      if (subtree.getDepth__() > currentDepth) {
        var rightContour: JavaArray = subtree.getContourRight__();
        var rightOffset: int = clientArea.right__() - transposer_1.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(subtree.getBounds__()).right__();
        this.mergeContour___3I_3III(cachedContourRight, rightContour, currentDepth, rightOffset);
        currentDepth = subtree.getDepth__();
      }
    }
    return;
  }
  public override function updateRowHeights__(): void {
    var transposer_1: Transposer = this.getTransposer__();
    preferredRowHeights = new JavaArray("[I").lengths(this.getDepth__());
    preferredRowHeights[0] = transposer_1.t__Lorg_eclipse_draw2d_geometry_Dimension_2(branch.getNode__().getPreferredSize__()).height + this.getMajorSpacing__();
    if (!branch.isExpanded__())
      return;
    var subtrees: List = this.getSubtrees__();
    var subtree: TreeBranch;
    for (var i: int = 0; i < subtrees.size__(); i++) {
      subtree = TreeBranch(subtrees.get__I(i));
      var rowHeights: JavaArray = subtree.getPreferredRowHeights__();
      for (var row: int = 0; row < rowHeights.length; row++)
        preferredRowHeights[row + 1] = Math__.max__II(preferredRowHeights[row + 1], rowHeights[row]);
    }
    return;
  }
  public override function setRowHeights___3II(heights: JavaArray, offset: int): void {
    super.setRowHeights___3II(heights, offset);
    if (branch.isExpanded__()) {
      var subtrees: List = this.getSubtrees__();
      offset++;
      for (var i: int = 0; i < subtrees.size__(); i++)
        (TreeBranch(subtrees.get__I(i))).setRowHeights___3II(heights, offset);
    }
    return;
  }
}
}
