package org.eclipse.swt.e4.examples.draw2d {
import org.eclipse.swt.graphics.Color;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Arguments;
dynamic public class PageNode extends Figure {
  private var selected: Boolean;
  public static var gradient1: Color = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [null, 232, 232, 240]));
  public static var gradient2: Color = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [null, 176, 184, 216]));
  public static var corner1: Color = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [null, 200, 208, 223]));
  public static var corner2: Color = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [null, 160, 172, 200]));
  public static var blue: Color = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [null, 152, 168, 200]));
  public static var shadow: Color = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [null, 202, 202, 202]));
  public static const CORNER_SIZE: int = 10;
  public static var BORDER: Border = new CompoundBorder(new Arguments(org.eclipse.draw2d.CompoundBorder.CompoundBorder__Lorg_eclipse_draw2d_Border_2Lorg_eclipse_draw2d_Border_2, [new PageNode$FoldedPageBorder(), new MarginBorder(new Arguments(org.eclipse.draw2d.MarginBorder.MarginBorder__IIII, [4, 4, 8, 3]))]));
  private var label: Label = new Label(new Arguments(org.eclipse.draw2d.Label.Label__, []));
  public function PageNode__Ljava_lang_String_2(text: String): Object {
    label.setText__Ljava_lang_String_2(text);
    return this;
  }
  public function PageNode__(): Object {
    this.setBorder__Lorg_eclipse_draw2d_Border_2(BORDER);
    this.setLayoutManager__Lorg_eclipse_draw2d_LayoutManager_2(new StackLayout());
    this.add__Lorg_eclipse_draw2d_IFigure_2(label);
    return this;
  }
  public override function paintFigure__Lorg_eclipse_draw2d_Graphics_2(g: Graphics): void {
    super.paintFigure__Lorg_eclipse_draw2d_Graphics_2(g);
    if (selected) {
      g.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.menuBackgroundSelected);
      g.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.titleGradient);
    } else {
      g.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(gradient1);
      g.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(gradient2);
    }
    g.fillGradient__Lorg_eclipse_draw2d_geometry_Rectangle_2Z(this.getBounds__().getResized__II(-3, -3), true);
    return;
  }
  public function setSelected__Z(value: Boolean): void {
    this.selected = value;
    if (selected)
      label.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.white);
    else
      label.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(null);
    this.repaint__();
    return;
  }
  public function toString__(): String {
    return (Label(this.getChildren__().get__I(0))).getText__();
  }
  public function PageNode(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 0) {
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        break;
      case 1:
        break;
    }
    super();
    switch (id) {
      case 0:
        PageNode__();
        PageNode__Ljava_lang_String_2(args0[0]);
        break;
      case 1:
        PageNode__();
        break;
    }
  }
  public static const PageNode__Ljava_lang_String_2 : int = 0;
  public static const PageNode__ : int = 1;
}
}
