package org.eclipse.swt.e4.examples.draw2d {
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Display;
import java.util.List;
import java.lang.Runnable;
import java.lang.Arguments;
import java.lang.JavaArray;
import java.lang.System;
dynamic public class TreeBranch extends Figure {
  public static const STYLE_HANGING: int = 1;
  public static const STYLE_NORMAL: int = 2;
  internal var aligment: int = 2;
  internal var contents: TreeBranch$AnimatingLayer = new TreeBranch$AnimatingLayer(TreeBranch(this));
  internal var expanded: Boolean = true;
  internal var node: IFigure;
  internal var style: int;
  public function TreeBranch__Lorg_eclipse_draw2d_IFigure_2(title: IFigure): Object {
    return this;
  }
  public function TreeBranch__Lorg_eclipse_draw2d_IFigure_2I(title: IFigure, style: int): Object {
    this.setStyle__I(style);
    if (title.getBorder__() === null)
      title.setBorder__Lorg_eclipse_draw2d_Border_2(new LineBorder(new Arguments(org.eclipse.draw2d.LineBorder.LineBorder__Lorg_eclipse_swt_graphics_Color_2I, [org.eclipse.draw2d.ColorConstants$$fields.gray, 2])));
    this.node = title;
    this.add__Lorg_eclipse_draw2d_IFigure_2(contents);
    this.add__Lorg_eclipse_draw2d_IFigure_2(title);
    return this;
  }
  public function animationReset__Lorg_eclipse_draw2d_geometry_Rectangle_2(bounds_1: Rectangle): void {
    var subtrees: List = contents.getChildren__();
    contents.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(bounds_1);
    var r: Rectangle = node.getBounds__();
    var dx: int = bounds_1.x + int(bounds_1.width / 2) - r.x - int(r.width / 2);
    var dy: int = bounds_1.y + int(bounds_1.height / 2) - r.y - int(r.height / 2);
    node.translate__II(dx, dy);
    this.revalidate__();
    for (var i: int = 0; i < subtrees.size__(); i++) {
      var subtree: TreeBranch = TreeBranch(subtrees.get__I(i));
      subtree.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(bounds_1);
      subtree.animationReset__Lorg_eclipse_draw2d_geometry_Rectangle_2(bounds_1);
    }
    return;
  }
  public function collapse__(): void {
    if (!expanded)
      return;
    var root: IFigure = this;
    var port: Viewport = null;
    var viewportStart: Point = null;
    while (root.getParent__() !== null) {
      if (root is Viewport)
        port = (Viewport(root));
      root = root.getParent__();
    }
    viewportStart = port.getViewLocation__();
    var nodeStart: Point = node.getBounds__().getLocation__();
    this.setExpanded__Z(false);
    root.validate__();
    this.setExpanded__Z(true);
    this.animationReset__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.getNodeBounds__());
    Animation.mark__Lorg_eclipse_draw2d_IFigure_2(this.getNode__());
    Animation.captureLayout__Lorg_eclipse_draw2d_IFigure_2(this.getRoot__());
    Animation.swap__();
    Animation.trackLocation = nodeStart;
    root.validate__();
    port.setViewLocation__Lorg_eclipse_draw2d_geometry_Point_2(viewportStart);
    var display: Display = Display.getCurrent__();
    display.asyncExec__Ljava_lang_Runnable_2(new org.eclipse.swt.e4.examples.draw2d.TreeBranch$1(this, display));
    return;
  }
  public override function containsPoint__II(x: int, y: int): Boolean {
    return node.containsPoint__II(x, y) || contents.containsPoint__II(x, y);
  }
  public function expand__(): void {
    if (expanded)
      return;
    this.setExpanded__Z(true);
    this.animationReset__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.getNodeBounds__());
    Animation.mark__Lorg_eclipse_draw2d_IFigure_2(this.getNode__());
    Animation.captureLayout__Lorg_eclipse_draw2d_IFigure_2(this.getRoot__());
    var display: Display = Display.getCurrent__();
    display.asyncExec__Ljava_lang_Runnable_2(new org.eclipse.swt.e4.examples.draw2d.TreeBranch$2(this, display));
    return;
  }
  public function getAlignment__(): int {
    return aligment;
  }
  public function getBranchLayout__(): BranchLayout {
    return BranchLayout(this.getLayoutManager__());
  }
  public function getContentsPane__(): IFigure {
    return contents;
  }
  public function getContourLeft__(): JavaArray {
    return this.getBranchLayout__().getContourLeft__();
  }
  public function getContourRight__(): JavaArray {
    return this.getBranchLayout__().getContourRight__();
  }
  public function getDepth__(): int {
    return this.getBranchLayout__().getDepth__();
  }
  public override function getMinimumSize__II(wHint: int, hHint: int): Dimension {
    if (!Animation.PLAYBACK)
      this.validate__();
    return super.getMinimumSize__II(wHint, hHint);
  }
  public function getNode__(): IFigure {
    return node;
  }
  public function getNodeBounds__(): Rectangle {
    return node.getBounds__();
  }
  public function getPreferredRowHeights__(): JavaArray {
    return this.getBranchLayout__().getPreferredRowHeights__();
  }
  public override function getPreferredSize__II(wHint: int, hHint: int): Dimension {
    if (!Animation.PLAYBACK)
      this.validate__();
    return super.getPreferredSize__II(wHint, hHint);
  }
  public function getRoot__(): TreeRoot {
    return (TreeBranch(this.getParent__().getParent__())).getRoot__();
  }
  public function getStyle__(): int {
    return style;
  }
  public function isExpanded__(): Boolean {
    return expanded;
  }
  public override function paintFigure__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    super.paintFigure__Lorg_eclipse_draw2d_Graphics_2(graphics);
    if (this.isExpanded__())
      this.getBranchLayout__().paintLines__Lorg_eclipse_draw2d_Graphics_2(graphics);
  }
  public function setAlignment__I(value: int): void {
    aligment = value;
    this.revalidate__();
  }
  public function setExpanded__Z(b: Boolean): void {
    if (expanded == b)
      return;
    expanded = b;
    contents.setVisible__Z(b);
    this.revalidate__();
  }
  public function setNode__Lorg_eclipse_draw2d_IFigure_2(node_1: IFigure): void {
    this.remove__Lorg_eclipse_draw2d_IFigure_2(this.node);
    this.add__Lorg_eclipse_draw2d_IFigure_2I(this.node, 0);
  }
  public function setRowHeights___3II(heights: JavaArray, offset: int): void {
    this.getBranchLayout__().setRowHeights___3II(heights, offset);
  }
  public function setStyle__I(style_1: int): void {
    if (this.style == style_1)
      return;
    this.style = style_1;
    switch (style_1) {
      case 1 :
        this.setLayoutManager__Lorg_eclipse_draw2d_LayoutManager_2(new HangingLayout(this));
        break;
      default :
        this.setLayoutManager__Lorg_eclipse_draw2d_LayoutManager_2(new NormalLayout(this));
        contents.setLayoutManager__Lorg_eclipse_draw2d_LayoutManager_2(new TreeLayout());
        break;
    }
  }
  public function toString__(): String {
    return this.toString__I(0);
  }
  public function toString__I(level: int): String {
    var result: String = "";
    for (var i: int = 0; i < level; i++)
      result += "  ";
    result += java.lang.System.stringValueOf(this.getChildren__().get__I(1)) + "\n";
    for (var i_1: int = 0; i_1 < contents.getChildren__().size__(); i_1++)
      result += (TreeBranch(contents.getChildren__().get__I(i_1))).toString__I(level + 1);
    return result;
  }
  public override function validate__(): void {
    if (this.isValid__())
      return;
    if (style == 1) {
      var layout: ToolbarLayout = new org.eclipse.swt.e4.examples.draw2d.TreeBranch$3(this, !this.getRoot__().isHorizontal__());
      layout.setMinorAlignment__I(1);
      layout.setStretchMinorAxis__Z(false);
      contents.setLayoutManager__Lorg_eclipse_draw2d_LayoutManager_2(layout);
    }
    this.repaint__();
    super.validate__();
    return;
  }
  public function TreeBranch(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is IFigure) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is IFigure && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        args1 = [args0[0], 2];
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        TreeBranch__Lorg_eclipse_draw2d_IFigure_2I(args1[0], args1[1]);
        TreeBranch__Lorg_eclipse_draw2d_IFigure_2(args0[0]);
        break;
      case 1:
        TreeBranch__Lorg_eclipse_draw2d_IFigure_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const TreeBranch__Lorg_eclipse_draw2d_IFigure_2 : int = 0;
  public static const TreeBranch__Lorg_eclipse_draw2d_IFigure_2I : int = 1;
}
}
