package org.eclipse.swt.e4.examples.draw2d {
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.MouseListener$Stub;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TreeExample extends AbstractExample {
  internal var animate: Boolean;
  internal var root: TreeRoot;
  internal var selected: PageNode;
  public static function main___3Ljava_lang_String_2(args: JavaArray): void {
    new TreeExample().run__();
    return;
  }
  public function createPageNode__Ljava_lang_String_2(title: String): IFigure {
    var node: PageNode = new PageNode(new Arguments(org.eclipse.swt.e4.examples.draw2d.PageNode.PageNode__Ljava_lang_String_2, [title]));
    node.addMouseListener__Lorg_eclipse_draw2d_MouseListener_2(new org.eclipse.swt.e4.examples.draw2d.TreeExample$1(this, node));
    return node;
  }
  public function doAddChild__(): void {
    if (selected === null)
      return;
    var parent: TreeBranch = TreeBranch(selected.getParent__());
    parent.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2I, [this.createPageNode__Ljava_lang_String_2("child"), parent.getStyle__()])));
  }
  public function doAlignCenter__(): void {
    if (selected === null)
      return;
    var parent: TreeBranch = TreeBranch(selected.getParent__());
    parent.setAlignment__I(2);
  }
  public function doAlignLeft__(): void {
    if (selected === null)
      return;
    var parent: TreeBranch = TreeBranch(selected.getParent__());
    parent.setAlignment__I(1);
  }
  public function doDeleteChild__(): void {
    if (selected === null)
      return;
    var parent: TreeBranch = TreeBranch(selected.getParent__());
    var contents_1: IFigure = parent.getContentsPane__();
    if (contents_1.getChildren__().isEmpty__())
      return;
    contents_1.remove__Lorg_eclipse_draw2d_IFigure_2(IFigure(contents_1.getChildren__().get__I(contents_1.getChildren__().size__() - 1)));
  }
  public function doExpandCollapse__(): void {
    if (selected === null)
      return;
    var parent: TreeBranch = TreeBranch(selected.getParent__());
    if (parent.getContentsPane__().getChildren__().isEmpty__())
      return;
    if (animate) {
      if (parent.isExpanded__())
        parent.collapse__();
      else
        parent.expand__();
    } else
      parent.setExpanded__Z(!parent.isExpanded__());
    return;
  }
  public function doStyleHanging__(): void {
    if (selected === null)
      return;
    var parent: TreeBranch = TreeBranch(selected.getParent__());
    parent.setStyle__I(1);
  }
  public function doStyleNormal__(): void {
    if (selected === null)
      return;
    var parent: TreeBranch = TreeBranch(selected.getParent__());
    parent.setStyle__I(2);
  }
  public override function getContents__(): IFigure {
    this.getFigureCanvas__().setBackground__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.white);
    root = new TreeRoot(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeRoot.TreeRoot__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("Graph Root")]));
    var branch: TreeBranch;
    var subbranch: TreeBranch;
    root.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(branch = new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("Normal Style")])));
    root.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("Child")])));
    branch.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("Child 1")])));
    branch.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("Child 2")])));
    branch.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(subbranch = new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("Child 3")])));
    subbranch.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("child")])));
    subbranch.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("child")])));
    subbranch.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("child")])));
    root.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(branch = new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2I, [this.createPageNode__Ljava_lang_String_2("Normal Style"), 2])));
    root.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("Child")])));
    branch.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2I, [this.createPageNode__Ljava_lang_String_2("Child 1"), 1])));
    branch.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(subbranch = new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2I, [this.createPageNode__Ljava_lang_String_2("Child 2"), 1])));
    subbranch.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("child")])));
    subbranch.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("child")])));
    root.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(branch = new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("Normal Style")])));
    branch.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("Child 1")])));
    branch.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("Child 2")])));
    branch.getContentsPane__().add__Lorg_eclipse_draw2d_IFigure_2(new TreeBranch(new Arguments(org.eclipse.swt.e4.examples.draw2d.TreeBranch.TreeBranch__Lorg_eclipse_draw2d_IFigure_2, [this.createPageNode__Ljava_lang_String_2("Child 3")])));
    return root;
  }
  public override function hookShell__(): void {
    var localShell: Composite = new Composite(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [shell, 0]));
    localShell.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [1040])));
    localShell.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    var rootGroup: Group = new Group(localShell, 0);
    rootGroup.setText__Ljava_lang_String_2("Root Properties");
    var data: FontData = rootGroup.getFont__().getFontData__()[0];
    data.setStyle__I(1);
    rootGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    var orientation: Button = new Button(rootGroup, 32);
    orientation.setText__Ljava_lang_String_2("Horizontal Orientation");
    orientation.setSelection__Z(true);
    orientation.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.e4.examples.draw2d.TreeExample$2(this, orientation));
    var useAnimation: Button = new Button(rootGroup, 32);
    useAnimation.setText__Ljava_lang_String_2("Use Animation");
    useAnimation.setSelection__Z(false);
    useAnimation.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.e4.examples.draw2d.TreeExample$3(this, useAnimation));
    var compress: Button = new Button(rootGroup, 32);
    compress.setText__Ljava_lang_String_2("Compress Tree");
    compress.setSelection__Z(false);
    compress.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.e4.examples.draw2d.TreeExample$4(this, compress));
    var majorLabel: Label = new Label(rootGroup, 0);
    majorLabel.setText__Ljava_lang_String_2("Major Spacing: 10");
    var major: Scale = new Scale(rootGroup, 0);
    major.setMinimum__I(5);
    major.setIncrement__I(5);
    major.setMaximum__I(50);
    major.setSelection__I(10);
    major.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.e4.examples.draw2d.TreeExample$5(this, major, majorLabel));
    var minorLabel: Label = new Label(rootGroup, 0);
    minorLabel.setText__Ljava_lang_String_2("Minor Spacing: 10");
    var minor: Scale = new Scale(rootGroup, 0);
    minor.setMinimum__I(5);
    minor.setIncrement__I(5);
    minor.setMaximum__I(50);
    minor.setSelection__I(10);
    minor.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.e4.examples.draw2d.TreeExample$6(this, minor, minorLabel));
    var selectedGroup: Group = new Group(localShell, 0);
    selectedGroup.setText__Ljava_lang_String_2("Selected Node:");
    selectedGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [2, true])));
    var addChild: Button = new Button(selectedGroup, 0);
    addChild.setText__Ljava_lang_String_2("More Children");
    addChild.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.e4.examples.draw2d.TreeExample$7(this));
    var removeChild: Button = new Button(selectedGroup, 0);
    removeChild.setText__Ljava_lang_String_2("Fewer Children");
    removeChild.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.e4.examples.draw2d.TreeExample$8(this));
    var alignCenter: Button = new Button(selectedGroup, 0);
    alignCenter.setText__Ljava_lang_String_2("Align Center");
    alignCenter.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.e4.examples.draw2d.TreeExample$9(this));
    var alignLeft: Button = new Button(selectedGroup, 0);
    alignLeft.setText__Ljava_lang_String_2("Align Top/Left");
    alignLeft.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.e4.examples.draw2d.TreeExample$10(this));
    var normal: Button = new Button(selectedGroup, 0);
    normal.setText__Ljava_lang_String_2("Normal");
    normal.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.e4.examples.draw2d.TreeExample$11(this));
    var hanging: Button = new Button(selectedGroup, 0);
    hanging.setText__Ljava_lang_String_2("Hanging");
    hanging.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.e4.examples.draw2d.TreeExample$12(this));
    var expandCollapse: Button = new Button(selectedGroup, 0);
    expandCollapse.setText__Ljava_lang_String_2("expand/collapse");
    expandCollapse.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.e4.examples.draw2d.TreeExample$13(this));
  }
  public function setSelected__Lorg_eclipse_swt_e4_examples_draw2d_PageNode_2(node: PageNode): void {
    if (selected !== null) {
      selected.setSelected__Z(false);
    }
    selected = node;
    selected.setSelected__Z(true);
    return;
  }
}
}
