package org.eclipse.swt.e4.examples.draw2d {
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import java.util.List;
import java.lang.Math__;
import java.lang.System;
import java.lang.Integer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TreeLayout extends AbstractLayout {
  private var pointOfContact: int;
  public override function calculatePreferredSize__Lorg_eclipse_draw2d_IFigure_2II(container: IFigure, wHint: int, hHint: int): Dimension {
    container.validate__();
    var children: List = container.getChildren__();
    var result: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, [])).setLocation__Lorg_eclipse_draw2d_geometry_Point_2(container.getClientArea__().getLocation__());
    for (var i: int = 0; i < children.size__(); i++)
      result.union__Lorg_eclipse_draw2d_geometry_Rectangle_2((IFigure(children.get__I(i))).getBounds__());
    result.resize__II(container.getInsets__().getWidth__(), container.getInsets__().getHeight__());
    return result.getSize__();
  }
  private function calculateNewRightContour___3I_3II(old: JavaArray, add: JavaArray, shift: int): JavaArray {
    if (old === null)
      return add;
    var result: JavaArray = new JavaArray("[I").lengths(Math__.max__II(old.length, add.length));
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(add, 0, result, 0, add.length);
    for (var i: int = add.length; i < result.length; i++)
      result[i] = old[i] + shift;
    return result;
  }
  private function calculateOverlap___3I_3I(leftSubtree: JavaArray, rightSubtree: JavaArray): int {
    pointOfContact = 0;
    if (leftSubtree === null)
      return 0;
    var min: int = Math__.min__II(leftSubtree.length, rightSubtree.length);
    var result: int = 2147483647;
    for (var i: int = 0; i < min; i++) {
      var current: int = leftSubtree[i] + rightSubtree[i];
      if (i > 0)
        current -= 5;
      if (current < result) {
        result = current;
        pointOfContact = i + 1;
      }
    }
    return result;
  }
  public override function layout__Lorg_eclipse_draw2d_IFigure_2(container: IFigure): void {
    Animation.recordInitialState__Lorg_eclipse_draw2d_IFigure_2(container);
    if (Animation.playbackState__Lorg_eclipse_draw2d_IFigure_2(container))
      return;
    var root: TreeRoot = (TreeBranch(container.getParent__())).getRoot__();
    var transposer: Transposer = root.getTransposer__();
    var gap: int = root.getMinorSpacing__();
    var subtrees: List = container.getChildren__();
    var subtree: TreeBranch;
    var previousSubtreeDepth: int = 0;
    var rightContour: JavaArray = null;
    var leftContour: JavaArray;
    var contactDepth: int;
    var reference: Point = transposer.t__Lorg_eclipse_draw2d_geometry_Point_2(container.getBounds__().getLocation__());
    var currentXY: Point = reference.getCopy__();
    for (var i: int = 0; i < subtrees.size__(); i++) {
      subtree = TreeBranch(subtrees.get__I(i));
      var subtreeSize: Dimension = subtree.getPreferredSize__();
      subtree.setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(subtreeSize);
      subtreeSize = transposer.t__Lorg_eclipse_draw2d_geometry_Dimension_2(subtreeSize);
      leftContour = subtree.getContourLeft__();
      var overlap: int = this.calculateOverlap___3I_3I(rightContour, leftContour);
      if (!subtree.getRoot__().isCompressed__())
        overlap = 0;
      contactDepth = pointOfContact;
      subtree.setLocation__Lorg_eclipse_draw2d_geometry_Point_2(transposer.t__Lorg_eclipse_draw2d_geometry_Point_2(currentXY.getTranslated__II(-overlap, 0)));
      var advance: int = gap + subtreeSize.width - overlap;
      rightContour = this.calculateNewRightContour___3I_3II(rightContour, subtree.getContourRight__(), advance);
      currentXY.x += advance;
      var shiftRight: int = reference.x - transposer.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(subtree.getBounds__()).x;
      if (shiftRight > 0) {
        currentXY.x += shiftRight;
        var correction: Point = transposer.t__Lorg_eclipse_draw2d_geometry_Point_2(new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [shiftRight, 0])));
        for (var j: int = 0; j <= i; j++)
          (IFigure(subtrees.get__I(j))).translate__II(correction.x, correction.y);
      }
      if (contactDepth > previousSubtreeDepth) {
        var branch: TreeBranch = TreeBranch(subtrees.get__I(i - 1));
        var slack: int = transposer.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(subtree.getBounds__()).x - transposer.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(branch.getBounds__()).right__() - gap + this.calculateOverlap___3I_3I(branch.getContourRight__(), subtree.getContourLeft__());
        var end: int = i;
        var begin: int = end - 1;
        while (begin > 0 && (TreeBranch(subtrees.get__I(begin))).getDepth__() < contactDepth)
          begin--;
        for (var j_1: int = begin + 1; j_1 < end; j_1++) {
          branch = TreeBranch(subtrees.get__I(j_1));
          var shift: Point = transposer.t__Lorg_eclipse_draw2d_geometry_Point_2(new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [int(slack * (j_1 - begin) / (end - begin)), 0])));
          branch.translate__II(shift.x, shift.y);
        }
      }
      previousSubtreeDepth = subtree.getDepth__();
    }
    return;
  }
}
}
