package org.eclipse.swt.e4.examples.flickrviewer {
import org.eclipse.swt.SWT;
import org.eclipse.swt.animation.*;
import org.eclipse.swt.effects.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.animation.PropertyAnimation;
import org.eclipse.swt.animation.LinearPropertyAnimation;
import java.lang.Integer;
import java.lang.Math__;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.effects.GlowEffect;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Dock extends Composite {
  public static const MARGIN: int = 6;
  public static const SLIDE_DURATION: Number = 600;
  public static const ZOOM_DURATION: Number = 200;
  internal var slider: Composite;
  internal var thumbnails: Composite;
  internal var next: Button;
  internal var previous: Button;
  internal var size: Point;
  internal var zoomSize: Point;
  internal var glowColor: Color;
  internal var selected: ImageCanvas;
  public function Dock(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, style]));
    var layout: GridLayout = new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [3, false]));
    layout.marginWidth = layout.marginHeight = 0;
    this.setLayout__Lorg_eclipse_swt_widgets_Layout_2(layout);
    glowColor = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [this.getDisplay__(), 102, 153, 204]));
    previous = new Button(this, 8);
    previous.setText__Ljava_lang_String_2("<");
    previous.setToolTipText__Ljava_lang_String_2("Previous Page");
    previous.setEnabled__Z(false);
    slider = new Composite(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [this, 0]));
    slider.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [1808])));
    thumbnails = new Composite(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [slider, 0]));
    var listener: Listener = new org.eclipse.swt.e4.examples.flickrviewer.Dock$1(this);
    thumbnails.addListener__ILorg_eclipse_swt_widgets_Listener_2(10, listener);
    thumbnails.addListener__ILorg_eclipse_swt_widgets_Listener_2(11, listener);
    next = new Button(this, 8);
    next.setText__Ljava_lang_String_2(">");
    next.setToolTipText__Ljava_lang_String_2("Next Page");
    next.setEnabled__Z(false);
    next.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.e4.examples.flickrviewer.Dock$2(this));
    previous.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.e4.examples.flickrviewer.Dock$3(this));
    return;
  }
  public function removeAll__(): void {
    selected = null;
    var children_1: JavaArray = thumbnails.getChildren__();
    for (var i: int = 0; i < children_1.length; i++) {
      var control: Control = children_1[i];
      control.dispose__();
    }
    thumbnails.setBounds__IIII(0, 0, 0, slider.getBounds__().height);
    return;
  }
  public function add__Lorg_eclipse_swt_graphics_Image_2Ljava_lang_String_2Ljava_lang_Object_2(image: Image, description: String, data_1: Object): void {
    var label: ImageCanvas = new ImageCanvas(thumbnails, 0);
    label.setImage__Lorg_eclipse_swt_graphics_Image_2(image);
    label.setToolTipText__Ljava_lang_String_2(description);
    label.setData__Ljava_lang_Object_2(data_1);
    label.addListener__ILorg_eclipse_swt_widgets_Listener_2(6, new org.eclipse.swt.e4.examples.flickrviewer.Dock$4(this));
    label.addListener__ILorg_eclipse_swt_widgets_Listener_2(7, new org.eclipse.swt.e4.examples.flickrviewer.Dock$5(this));
    label.addListener__ILorg_eclipse_swt_widgets_Listener_2(11, new org.eclipse.swt.e4.examples.flickrviewer.Dock$6(this));
    label.addListener__ILorg_eclipse_swt_widgets_Listener_2(3, new org.eclipse.swt.e4.examples.flickrviewer.Dock$7(this));
    label.setSize__Lorg_eclipse_swt_graphics_Point_2(size);
    return;
  }
  public function setSelected__Lorg_eclipse_swt_e4_examples_flickrviewer_ImageCanvas_2(widget: ImageCanvas): void {
    if (selected === widget)
      return;
    if (selected !== null) {
      selected.setEffect__Lorg_eclipse_swt_effects_Effect_2(null);
    }
    selected = widget;
    var effect: GlowEffect = new GlowEffect();
    effect.setColor__Lorg_eclipse_swt_graphics_Color_2(glowColor);
    effect.setSize__D(10);
    selected.setEffect__Lorg_eclipse_swt_effects_Effect_2(effect);
    var ev: Event = new Event();
    ev.data = widget.getData__();
    this.notifyListeners__ILorg_eclipse_swt_widgets_Event_2(13, ev);
    return;
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    var width_1: int = 0;
    width_1 += previous.computeSize__II(-1, -1).x;
    width_1 += next.computeSize__II(-1, -1).x;
    width_1 += (thumbnails.getChildren__().length * (zoomSize.x + 6)) + 6;
    var height_1: int = zoomSize.y + 6 * 2;
    if (wHint != -1)
      width_1 = wHint;
    if (hHint != -1)
      height_1 = hHint;
    var trim: Rectangle = this.computeTrim__IIII(0, 0, width_1, height_1);
    return new Point(trim.width, trim.height);
  }
  public function setThumbSize__Lorg_eclipse_swt_graphics_Point_2(pt: Point): void {
    size = pt;
  }
  public function setZoomSize__Lorg_eclipse_swt_graphics_Point_2(pt: Point): void {
    zoomSize = pt;
  }
}
}
