package org.eclipse.swt.e4.examples.flickrviewer {
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.net.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.net.FlickrUtil;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class FlickrViewer extends Composite {
  internal var dock: Dock;
  internal var view: View;
  internal var searchPane: SearchPane;
  internal var startPhoto: String;
  public function FlickrViewer(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, style]));
    this.create__();
    return;
  }
  public function create__(): void {
    var parent_1: Composite = this.getParent__();
    var composite: Composite = this;
    composite.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [1, false])));
    view = new View(composite, 0);
    view.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [1808])));
    dock = new Dock(composite, 0);
    dock.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [768])));
    dock.setThumbSize__Lorg_eclipse_swt_graphics_Point_2(new Point(50, 37));
    dock.setZoomSize__Lorg_eclipse_swt_graphics_Point_2(new Point(100, 74));
    var listener2: Listener = new org.eclipse.swt.e4.examples.flickrviewer.FlickrViewer$1(this);
    dock.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, listener2);
    searchPane = new SearchPane(parent_1, 0);
    searchPane.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.e4.examples.flickrviewer.FlickrViewer$2(this, composite));
    searchPane.moveAbove__Lorg_eclipse_swt_widgets_Control_2(null);
    var searchButton: Link = new Link(composite, 0);
    searchButton.setText__Ljava_lang_String_2("<A>New search</A>");
    searchButton.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [16777216, 16777216, true, false])));
    searchButton.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.e4.examples.flickrviewer.FlickrViewer$3(this, composite));
    parent_1.addListener__ILorg_eclipse_swt_widgets_Listener_2(11, new org.eclipse.swt.e4.examples.flickrviewer.FlickrViewer$4(this, parent_1, composite));
    parent_1.addListener__ILorg_eclipse_swt_widgets_Listener_2(11, new org.eclipse.swt.e4.examples.flickrviewer.FlickrViewer$5(this, parent_1));
    return;
  }
  public function search__Ljava_lang_String_2I(tag: String, count: int): void {
    var listener0: Listener = new org.eclipse.swt.e4.examples.flickrviewer.FlickrViewer$6(this);
    var parameters: JavaArray = new JavaArray("[Ljava/lang/String;").values("tags", tag, "per_page", Object(String).valueOf__I(count));
    var method: String = "flickr.photos.search";
    var request: FlickrRequest = new FlickrRequest(method, parameters);
    request.send__Lorg_eclipse_swt_widgets_Listener_2(listener0);
    return;
  }
  public function setStartPhoto__Ljava_lang_String_2(photo: String): void {
    startPhoto = photo;
    return;
  }
  public function getPhotosInfo__Ljava_lang_Object_2(object_1: Object): JavaArray {
    var photos: JavaArray = FlickrUtil.getPhotosInfo__Ljava_lang_Object_2(object_1);
    var infos: JavaArray = new JavaArray("[Lorg/eclipse/swt/e4/examples/flickrviewer/PhotoInfo;").lengths(int(photos.length / 3));
    for (var i: int = 0, j: int = 0; i < infos.length; i++) {
      var info: PhotoInfo = infos[i] = new PhotoInfo();
      info.title = photos[j++];
      info.id = photos[j++];
      info.secret = photos[j++];
    }
    return infos;
  }
}
}
