package org.eclipse.swt.e4.examples.flickrviewer {
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.net.FlickrUtil;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import java.util.Vector;
import java.util.Enumeration;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PhotoInfo {
  public static const SIZE_SQUARE: String = "Square";
  public static const SIZE_THUMBNAIL: String = "Thumbnail";
  public static const SIZE_SMALL: String = "Small";
  public static const SIZE_MEDIUM: String = "Medium";
  public static const SIZE_LARGE: String = "Large";
  public var title: String;
  public var description: String;
  public var id: String;
  public var secret: String;
  internal var urls: Hashtable;
  internal var images: Hashtable;
  internal var listeners: Hashtable;
  public function PhotoInfo() {
    listeners = new Hashtable(new Arguments(java.util.Hashtable.Hashtable__, []));
    images = new Hashtable(new Arguments(java.util.Hashtable.Hashtable__, []));
    return;
  }
  public function getImage__Ljava_lang_String_2(size: String): Image {
    return Image(images.get__Ljava_lang_Object_2(size));
  }
  public function getImage__Ljava_lang_String_2Lorg_eclipse_swt_widgets_Listener_2(size: String, listener: Listener): void {
    var list: Vector = Vector(listeners.get__Ljava_lang_Object_2(size));
    if (list === null) {
      list = new Vector(new Arguments(java.util.Vector.Vector__, []));
      listeners.put__Ljava_lang_Object_2Ljava_lang_Object_2(size, list);
    }
    list.addElement__Ljava_lang_Object_2(listener);
    this.runListeners__();
    return;
  }
  public function dispose__(): void {
    if (images === null)
      return;
    var enumeration: Enumeration = images.elements__();
    while (enumeration.hasMoreElements__()) {
      var image: Image = Image(enumeration.nextElement__());
      image.dispose__();
    }
    listeners = null;
    images = null;
    urls = null;
    return;
  }
  public function runListeners__(): void {
    if (urls === null) {
      this.loadUrls__();
      return;
    }
    var sizes: Enumeration = listeners.keys__();
    while (sizes.hasMoreElements__()) {
      var size: String = String(sizes.nextElement__());
      var image: Image = Image(images.get__Ljava_lang_Object_2(size));
      if (image === null) {
        this.loadImage__Ljava_lang_String_2(size);
        continue;
      }
      var list: Vector = Vector(listeners.get__Ljava_lang_Object_2(size));
      if (list !== null) {
        var event: Event = new Event();
        event.data = this;
        for (var i: int = 0; i < list.size__(); i++) {
          var listener: Listener = Listener(list.remove__I(0));
          listener.handleEvent__Lorg_eclipse_swt_widgets_Event_2(event);
        }
      }
    }
    return;
  }
  public function loadImage__Ljava_lang_String_2(size: String): void {
    var url: String = String(urls.get__Ljava_lang_Object_2(size));
    var listener: Listener = new org.eclipse.swt.e4.examples.flickrviewer.PhotoInfo$1(this, size);
    FlickrUtil.setImage__Lorg_eclipse_swt_widgets_Listener_2Ljava_lang_String_2(listener, url);
    return;
  }
  public function loadUrls__(): void {
    urls = new Hashtable(new Arguments(java.util.Hashtable.Hashtable__, []));
    var listener: Listener = new org.eclipse.swt.e4.examples.flickrviewer.PhotoInfo$2(this);
    var parameters: JavaArray = new JavaArray("[Ljava/lang/String;").values("photo_id", id, "secret", secret);
    var method: String = "flickr.photos.getSizes";
    var request: FlickrRequest = new FlickrRequest(method, parameters);
    request.send__Lorg_eclipse_swt_widgets_Listener_2(listener);
    return;
  }
}
}
