package org.eclipse.swt.e4.examples.flickrviewer {
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.animation.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.animation.PropertyAnimation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.animation.LinearPropertyAnimation;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Point;
import java.lang.Arguments;
dynamic public class SearchPane extends Composite {
  public static var DURATION: Number = 400;
  internal var combo: Combo;
  internal var spinner: Spinner;
  internal var slide: PropertyAnimation;
  public function SearchPane(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, style]));
    var display: Display = this.getDisplay__();
    this.setBackground__Lorg_eclipse_swt_graphics_Color_2(display.getSystemColor__I(15));
    this.setAlpha__I(180);
    var layout: GridLayout = new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [4, false]));
    layout.marginHeight = layout.marginWidth = 20;
    this.setLayout__Lorg_eclipse_swt_widgets_Layout_2(layout);
    slide = new LinearPropertyAnimation();
    slide.setTarget__Ljava_lang_Object_2(this);
    slide.setProperty__Ljava_lang_String_2("location");
    slide.setDuration__J(DURATION);
    var label0: Label = new Label(this, 0);
    label0.setText__Ljava_lang_String_2("Search:");
    combo = new Combo(this, 4);
    combo.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__II, [160, -1])));
    combo.setAlpha__I(255);
    var label1: Label = new Label(this, 0);
    label1.setText__Ljava_lang_String_2("Count:");
    spinner = new Spinner(this, 0);
    spinner.setSelection__I(20);
    spinner.setAlpha__I(255);
    var listener: Listener = new org.eclipse.swt.e4.examples.flickrviewer.SearchPane$1(this);
    spinner.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, listener);
    combo.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, listener);
    combo.addListener__ILorg_eclipse_swt_widgets_Listener_2(1, new org.eclipse.swt.e4.examples.flickrviewer.SearchPane$2(this));
    this.pack__();
    return;
  }
  public function hide__(): void {
    slide.stop__();
    var clientArea: Rectangle = this.getParent__().getClientArea__();
    var bounds: Rectangle = this.getBounds__();
    slide.setFrom__Ljava_lang_Object_2(new Point(bounds.x, bounds.y));
    slide.setTo__Ljava_lang_Object_2(new Point(bounds.x, clientArea.height));
    slide.start__Lorg_eclipse_swt_widgets_Widget_2(this);
    return;
  }
  public function show__(): void {
    slide.stop__();
    var clientArea: Rectangle = this.getParent__().getClientArea__();
    var bounds: Rectangle = this.getBounds__();
    combo.setFocus__();
    var x_1: int = int((clientArea.width - bounds.width) / 2);
    var y_1: int = int((clientArea.height - bounds.height) / 2);
    slide.setFrom__Ljava_lang_Object_2(new Point(x_1, clientArea.height));
    slide.setTo__Ljava_lang_Object_2(new Point(x_1, y_1));
    slide.start__Lorg_eclipse_swt_widgets_Widget_2(this);
    return;
  }
  public function getText__(): String {
    return combo.getText__();
  }
  public function getCount__(): int {
    return spinner.getSelection__();
  }
}
}
