package org.eclipse.swt.e4.examples.flickrviewer {
import org.eclipse.swt.SWT;
import org.eclipse.swt.animation.*;
import org.eclipse.swt.effects.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.effects.DropShadowEffect;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import org.eclipse.swt.animation.PropertyAnimation;
import org.eclipse.swt.animation.LinearPropertyAnimation;
import java.lang.Integer;
import java.lang.Runnable;
import java.lang.Arguments;
dynamic public class View extends Composite {
  public static const FADE_TIME: int = 500;
  public static const BORDER: int = 4;
  internal var current: Label;
  internal var view: Label;
  internal var overlay: Label;
  internal var description: Label;
  internal var descriptionPanel: Composite;
  internal var image: Image;
  public function View(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, style]));
    var display: Display = this.getDisplay__();
    view = current = new Label(this, 0);
    overlay = new Label(this, 0);
    overlay.setAlpha__I(0);
    descriptionPanel = new Composite(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [this, 0]));
    descriptionPanel.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [1, false])));
    descriptionPanel.setBackground__Lorg_eclipse_swt_graphics_Color_2(display.getSystemColor__I(2));
    descriptionPanel.setAlpha__I(50);
    description = new Label(descriptionPanel, 0);
    description.setForeground__Lorg_eclipse_swt_graphics_Color_2(display.getSystemColor__I(1));
    description.setFont__Lorg_eclipse_swt_graphics_Font_2(new Font(new Arguments(org.eclipse.swt.graphics.Font.Font__Lorg_eclipse_swt_graphics_Device_2Ljava_lang_String_2II, [display, "Verdana", 14, 0])));
    description.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [16777216, 16777216, true, true])));
    descriptionPanel.moveAbove__Lorg_eclipse_swt_widgets_Control_2(null);
    var effect: DropShadowEffect = new DropShadowEffect();
    effect.setDistance__D(10);
    effect.setColor__Lorg_eclipse_swt_graphics_Color_2(new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [display, 102, 153, 204])));
    view.setEffect__Lorg_eclipse_swt_effects_Effect_2(effect);
    overlay.setEffect__Lorg_eclipse_swt_effects_Effect_2(effect);
    var enterListener: Listener = new org.eclipse.swt.e4.examples.flickrviewer.View$1(this);
    overlay.addListener__ILorg_eclipse_swt_widgets_Listener_2(6, enterListener);
    view.addListener__ILorg_eclipse_swt_widgets_Listener_2(6, enterListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(11, new org.eclipse.swt.e4.examples.flickrviewer.View$2(this));
    return;
  }
  public function setDescriptionVisible__Z(visible: Boolean): void {
    if (Object(description.getText__()).length__() == 0)
      return;
    var bounds: Rectangle = current.getBounds__();
    if (visible == (descriptionPanel.getSize__().y != 0))
      return;
    if (visible) {
      if (descriptionPanel.getSize__().y > 0)
        return;
      descriptionPanel.setBounds__IIII(bounds.x + 4, Math__.max__II(4, bounds.y + 4), bounds.width - 4 * 2, 0);
      var slideIn: PropertyAnimation = new LinearPropertyAnimation();
      slideIn.setTarget__Ljava_lang_Object_2(descriptionPanel);
      slideIn.setProperty__Ljava_lang_String_2("height");
      slideIn.setFrom__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [0])));
      slideIn.setTo__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [50])));
      slideIn.setDuration__J(400);
      slideIn.start__Lorg_eclipse_swt_widgets_Widget_2(descriptionPanel);
      this.getDisplay__().timerExec__ILjava_lang_Runnable_2(3000, new org.eclipse.swt.e4.examples.flickrviewer.View$3(this));
    } else {
      if (descriptionPanel.getSize__().y < 50)
        return;
      descriptionPanel.setBounds__IIII(bounds.x + 4, Math__.max__II(4, bounds.y + 4), bounds.width - 4 * 2, 0);
      var slideOut: PropertyAnimation = new LinearPropertyAnimation();
      slideOut.setTarget__Ljava_lang_Object_2(descriptionPanel);
      slideOut.setProperty__Ljava_lang_String_2("height");
      slideOut.setFrom__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [50])));
      slideOut.setTo__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [0])));
      slideOut.setDuration__J(400);
      slideOut.start__Lorg_eclipse_swt_widgets_Widget_2(descriptionPanel);
    }
    return;
  }
  public function setDescription__Ljava_lang_String_2(string: String): void {
    description.setText__Ljava_lang_String_2(string !== null ? string : "");
    var height_1: int = descriptionPanel.getSize__().y;
    if (height_1 > 0) {
      var bounds: Rectangle = current.getBounds__();
      descriptionPanel.setBounds__IIII(bounds.x + 4, Math__.max__II(4, bounds.y + 4), bounds.width - 4 * 2, height_1);
      descriptionPanel.layout__();
    }
    return;
  }
  public function setImage__Lorg_eclipse_swt_graphics_Image_2(image_1: Image): void {
    if (image_1 === this.image)
      return;
    this.image = image_1;
    var topLabel: Label = current;
    var bottomLabel: Label = topLabel === overlay ? view : overlay;
    var fadeOut: PropertyAnimation = new LinearPropertyAnimation();
    fadeOut.setTarget__Ljava_lang_Object_2(topLabel);
    fadeOut.setProperty__Ljava_lang_String_2("alpha");
    fadeOut.setTo__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [0])));
    fadeOut.setDuration__J(500);
    fadeOut.start__Lorg_eclipse_swt_widgets_Widget_2(topLabel);
    if (image_1 !== null) {
      var bounds: Rectangle = image_1.getBounds__();
      var parentBounds: Rectangle = this.getBounds__();
      var x_1: int = int((parentBounds.width - bounds.width) / 2);
      var y_1: int = int((parentBounds.height - bounds.height) / 2);
      bottomLabel.setBounds__IIII(x_1, y_1, bounds.width, bounds.height);
      bottomLabel.setImage__Lorg_eclipse_swt_graphics_Image_2(image_1);
      var fadeIn: PropertyAnimation = new LinearPropertyAnimation();
      fadeIn.setTarget__Ljava_lang_Object_2(bottomLabel);
      fadeIn.setProperty__Ljava_lang_String_2("alpha");
      fadeIn.setTo__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [255])));
      fadeIn.setDuration__J(500);
      fadeIn.start__Lorg_eclipse_swt_widgets_Widget_2(bottomLabel);
      current = bottomLabel;
    }
    return;
  }
}
}
