package org.eclipse.swt.e4.examples.st {
import org.eclipse.swt.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import java.util.*;
import org.eclipse.swt.custom.LineStyleListener;
import java.util.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.SWT;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class JavaLineStyler implements LineStyleListener {
  internal var scanner: JavaScanner = new JavaScanner();
  internal var tokenColors: JavaArray;
  internal var colors: JavaArray;
  internal var blockComments: Vector = new Vector(new Arguments(java.util.Vector.Vector__, []));
  public static const EOF: int = -1;
  public static const EOL: int = 10;
  public static const WORD: int = 0;
  public static const WHITE: int = 1;
  public static const KEY: int = 2;
  public static const COMMENT: int = 3;
  public static const STRING: int = 5;
  public static const OTHER: int = 6;
  public static const NUMBER: int = 7;
  public static const MAXIMUM_TOKEN: int = 8;
  public function JavaLineStyler() {
    this.initializeColors__();
    scanner = new JavaScanner();
    return;
  }
  public function getColor__I(type: int): Color {
    if (type < 0 || type >= tokenColors.length) {
      return null;
    }
    return colors[tokenColors[type]];
  }
  public function inBlockComment__II(start: int, end: int): Boolean {
    for (var i: int = 0; i < blockComments.size__(); i++) {
      var offsets: JavaArray = JavaArray(blockComments.elementAt__I(i));
      if ((offsets[0] >= start) && (offsets[0] <= end))
        return true;
      if ((offsets[1] >= start) && (offsets[1] <= end))
        return true;
      if ((offsets[0] <= start) && (offsets[1] >= end))
        return true;
    }
    return false;
  }
  public function initializeColors__(): void {
    var display: Display = Display.getDefault__();
    colors = new JavaArray("[Lorg/eclipse/swt/graphics/Color;").values(new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [display, new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [0, 0, 0]))])), new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [display, new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [127, 0, 85]))])), new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [display, new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [63, 127, 95]))])), new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [display, new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [42, 0, 255]))])));
    tokenColors = new JavaArray("[I").lengths(8);
    tokenColors[0] = 0;
    tokenColors[1] = 0;
    tokenColors[2] = 1;
    tokenColors[3] = 2;
    tokenColors[5] = 3;
    tokenColors[6] = 0;
    tokenColors[7] = 0;
  }
  public function disposeColors__(): void {
    for (var i: int = 0; i < colors.length; i++) {
      colors[i].dispose__();
    }
    return;
  }
  public function lineGetStyle__Lorg_eclipse_swt_custom_LineStyleEvent_2(event: LineStyleEvent): void {
    var styles: Vector = new Vector(new Arguments(java.util.Vector.Vector__, []));
    var token: int;
    var lastStyle: StyleRange;
    if (this.inBlockComment__II(event.lineOffset, event.lineOffset + Object(event.lineText).length__())) {
      styles.addElement__Ljava_lang_Object_2(new StyleRange(new Arguments(org.eclipse.swt.custom.StyleRange.StyleRange__IILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2, [event.lineOffset, Object(event.lineText).length__(), this.getColor__I(3), null])));
      event.styles = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(styles.size__());
      styles.copyInto___3Ljava_lang_Object_2(event.styles);
      return;
    }
    var defaultFgColor: Color = (Control(event.widget)).getForeground__();
    scanner.setRange__Ljava_lang_String_2(event.lineText);
    token = scanner.nextToken__();
    while (token != -1) {
      if (token == 6) {
      } else if (token != 1) {
        var color: Color = this.getColor__I(token);
        if ((!color.equals__Ljava_lang_Object_2(defaultFgColor)) || (token == 2)) {
          var style: StyleRange = new StyleRange(new Arguments(org.eclipse.swt.custom.StyleRange.StyleRange__IILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2, [scanner.getStartOffset__() + event.lineOffset, scanner.getLength__(), color, null]));
          if (token == 2) {
            style.fontStyle = 1;
          }
          if (styles.isEmpty__()) {
            styles.addElement__Ljava_lang_Object_2(style);
          } else {
            lastStyle = StyleRange(styles.lastElement__());
            if (lastStyle.similarTo__Lorg_eclipse_swt_custom_StyleRange_2(style) && (lastStyle.start + lastStyle.length == style.start)) {
              lastStyle.length += style.length;
            } else {
              styles.addElement__Ljava_lang_Object_2(style);
            }
          }
        }
      } else if ((!styles.isEmpty__()) && ((lastStyle = StyleRange(styles.lastElement__())).fontStyle == 1)) {
        var start: int = scanner.getStartOffset__() + event.lineOffset;
        lastStyle = StyleRange(styles.lastElement__());
        if (lastStyle.start + lastStyle.length == start) {
          lastStyle.length += scanner.getLength__();
        }
      }
      token = scanner.nextToken__();
    }
    event.styles = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(styles.size__());
    styles.copyInto___3Ljava_lang_Object_2(event.styles);
    return;
  }
  public function parseBlockComments__Ljava_lang_String_2(text: String): void {
    blockComments = new Vector(new Arguments(java.util.Vector.Vector__, []));
    var index: int = 0;
    var ch: int;
    var blkComment: Boolean = false;
    var cnt: int = 0;
    var offsets: JavaArray = new JavaArray("[I").lengths(2);
    var done: Boolean = false;
    while (!done) {
      ch = index < Object(text).length__() ? Object(text).charAt__I(index++) : -1;
      switch (ch) {
        case -1 :
          {
            if (blkComment) {
              offsets[1] = cnt;
              blockComments.addElement__Ljava_lang_Object_2(offsets);
            }
            done = true;
            break;
          }
        case 47 :
          {
            ch = index < Object(text).length__() ? Object(text).charAt__I(index++) : -1;
            if ((ch == 42) && (!blkComment)) {
              offsets = new JavaArray("[I").lengths(2);
              offsets[0] = cnt;
              blkComment = true;
              cnt++;
            } else {
              cnt++;
            }
            cnt++;
            break;
          }
        case 42 :
          {
            if (blkComment) {
              ch = index < Object(text).length__() ? Object(text).charAt__I(index++) : -1;
              cnt++;
              if (ch == 47) {
                blkComment = false;
                offsets[1] = cnt;
                blockComments.addElement__Ljava_lang_Object_2(offsets);
              }
            }
            cnt++;
            break;
          }
        default :
          {
            cnt++;
            break;
          }
      }
    }
    return;
  }
}
}
