package org.eclipse.swt.e4.examples.st {
import java.util.Hashtable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Font;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class STDemo {
  internal var display: Display;
  internal var text: StyledText;
  internal var stylesTable: Hashtable;
  internal var verifyCB: String;
  internal var styler: JavaLineStyler;
  public function STDemo() {
    return;
  }
  public function go__(): void {
    stylesTable = new Hashtable(new Arguments(java.util.Hashtable.Hashtable__, []));
    display = new Display(new Arguments(org.eclipse.swt.widgets.Display.Display__, []));
    var shell: Shell = new Shell(new Arguments(org.eclipse.swt.widgets.Shell.Shell__Lorg_eclipse_swt_widgets_Display_2I, [display, 8]));
    shell.setText__Ljava_lang_String_2("Demo");
    var layout: FillLayout = new FillLayout(new Arguments(org.eclipse.swt.layout.FillLayout.FillLayout__, []));
    shell.setLayout__Lorg_eclipse_swt_widgets_Layout_2(layout);
    text = new StyledText(shell, 512 | 256);
    text.addListener__ILorg_eclipse_swt_widgets_Listener_2(25, new org.eclipse.swt.e4.examples.st.STDemo$1(this));
    shell.open__();
    shell.addListener__ILorg_eclipse_swt_widgets_Listener_2(12, new org.eclipse.swt.e4.examples.st.STDemo$2(this));
    return;
  }
  public static function isWeb__(): Boolean {
    if (Object("flex").equals__Ljava_lang_Object_2(SWT.getPlatform__()))
      return true;
    if (Object("dojo").equals__Ljava_lang_Object_2(SWT.getPlatform__()))
      return true;
    return false;
  }
  public static function main___3Ljava_lang_String_2(args: JavaArray): void {
    new STDemo().go__();
    if (isWeb__())
      return;
    var display: Display = Display.getCurrent__();
    while (!display.isDisposed__()) {
      if (!display.readAndDispatch__())
        display.sleep__();
    }
    return;
  }
  public function callOut__Ljava_lang_String_2Ljava_lang_String_2II(callback: String, text_1: String, start: int, end: int): void {
    if (callback != null) {
    import flash.external.ExternalInterface;
    ExternalInterface.call(callback, text, start, end);
    }
  }
  public function setJavaStyler__Z(enabled: Boolean): void {
    if (enabled) {
      if (styler === null) {
        styler = new JavaLineStyler();
        styler.parseBlockComments__Ljava_lang_String_2(text.getText__());
        text.addLineStyleListener__Lorg_eclipse_swt_custom_LineStyleListener_2(styler);
      }
    } else {
      if (styler !== null) {
        text.removeLineStyleListener__Lorg_eclipse_swt_custom_LineStyleListener_2(styler);
        styler = null;
      }
    }
    text.redraw__();
    return;
  }
  public function getColor__I(c: int): Color {
    return new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [display, (c & 0xFF0000) >> 16, (c & 0xFF00) >> 8, c & 0xFF]));
  }
  public function createStyleFromCSS__Ljava_lang_String_2(key: String): StyleRange {
    import mx.styles.StyleManager;
    import mx.styles.CSSStyleDeclaration;
    var style : StyleRange = new StyleRange();
    
    var st : CSSStyleDeclaration = StyleManager.getStyleDeclaration(key);
    if (st != null) {
    var fg : * = st.getStyle("color");
    var bg : * = st.getStyle("backgroundColor");
    var underlineColor : * = st.getStyle("underlineColor");
    var borderColor : * = st.getStyle("borderColor");
    var strikeoutColor : * = st.getStyle("strikeoutColor");
    var fontWeight : String = st.getStyle("fontWeight");
    var fontStyle : String = st.getStyle("fontStyle");
    var underlineStyle : String = st.getStyle("underlineStyle");
    var borderStyle : String = st.getStyle("borderStyle");
    var strikeoutStyle : String = st.getStyle("strikeoutStyle");
    
    
    if (underlineStyle == "single") {
    style.underline = true;
    } else if (underlineStyle == "double") {
    style.underline = true;
    style.underlineStyle = SWT.UNDERLINE_DOUBLE;
    } else if (underlineStyle == "squiggle") {
    style.underline = true;
    style.underlineStyle = SWT.UNDERLINE_SQUIGGLE;
    } else if (underlineStyle == "error") {
    style.underline = true;
    style.underlineStyle = SWT.UNDERLINE_ERROR;
    }
    if (borderStyle == "solid") {
    style.borderStyle = SWT.BORDER_SOLID;
    }
    if (strikeoutStyle == "solid") {
    style.strikeout = true;
    }
    if (fontWeight == "bold") {
    style.fontStyle = SWT.BOLD;
    }
    if (fontStyle == "italic") {
    style.fontStyle |= SWT.ITALIC;
    }
    if (fg != undefined) {
    style.foreground = getColor__I(fg);
    }
    if (bg != undefined) {
    style.background = getColor__I(bg);
    }
    if (underlineColor != undefined) {
    style.underlineColor = getColor__I(underlineColor);
    }
    if (borderColor != undefined) {
    style.borderColor = getColor__I(borderColor);
    }
    if (strikeoutColor != undefined) {
    style.strikeoutColor = getColor__I(strikeoutColor);
    }
    }
    return style;
  }
  public function setText__Ljava_lang_String_2(string: String): void {
    text.setText__Ljava_lang_String_2(string);
  }
  public function getText__(): String {
    return text.getText__();
  }
  public function getSelection__(): Point {
    return text.getSelection__();
  }
  public function setSelection__II(start: int, end: int): void {
    text.setSelection__II(start, end);
  }
  public function addVerifyListener__Ljava_lang_String_2(JSMethod: String): void {
    this.verifyCB = JSMethod;
  }
  public function setStyleRange__II_3I_3Ljava_lang_String_2(start: int, length: int, ranges: JavaArray, styles: JavaArray): void {
    var styleRanges: JavaArray = this.getStyleRanges___3Ljava_lang_String_2(styles);
    text.setStyleRanges__II_3I_3Lorg_eclipse_swt_custom_StyleRange_2(start, length, ranges, styleRanges);
  }
  public function setStyleRange___3I_3Ljava_lang_String_2(ranges: JavaArray, styles: JavaArray): void {
    var styleRanges: JavaArray = this.getStyleRanges___3Ljava_lang_String_2(styles);
    text.setStyleRanges___3I_3Lorg_eclipse_swt_custom_StyleRange_2(ranges, styleRanges);
  }
  public function getStyleRanges___3Ljava_lang_String_2(styles: JavaArray): JavaArray {
    var styleRanges: JavaArray = new JavaArray("[Lorg/eclipse/swt/custom/StyleRange;").lengths(styles.length);
    for (var i: int = 0; i < styles.length; i++) {
      var key: String = styles[i];
      var style: StyleRange = StyleRange(stylesTable.get__Ljava_lang_Object_2(key));
      if (style === null) {
        style = this.createStyleFromCSS__Ljava_lang_String_2(key);
        stylesTable.put__Ljava_lang_Object_2Ljava_lang_Object_2(key, style);
      }
      styleRanges[i] = style;
    }
    return styleRanges;
  }
  public function setForeground__I(color: int): void {
    text.setForeground__Lorg_eclipse_swt_graphics_Color_2(this.getColor__I(color));
  }
  public function setBackground__I(color: int): void {
    text.setBackground__Lorg_eclipse_swt_graphics_Color_2(this.getColor__I(color));
  }
  public function getForeground__(): int {
    return text.getForeground__().handle;
  }
  public function getBackground__(): int {
    return text.getBackground__().handle;
  }
  public function getClientArea__(): Rectangle {
    return text.getClientArea__();
  }
  public function getLineHeight__(): int {
    return text.getLineHeight__();
  }
  public function setTopIndex__I(topIndex: int): void {
    text.setTopIndex__I(topIndex);
  }
  public function setTopPixel__I(topPixel: int): void {
    text.setTopPixel__I(topPixel);
  }
  public function setFont__Ljava_lang_String_2ILjava_lang_String_2Ljava_lang_String_2(fontFamily: String, fontSize: int, fontWeight: String, fontStyle: String): void {
    var style: int = 0;
    if (Object(fontWeight).equals__Ljava_lang_Object_2("bold"))
      style |= 1;
    if (Object(fontStyle).equals__Ljava_lang_Object_2("italic"))
      style |= 2;
    var font: Font = new Font(new Arguments(org.eclipse.swt.graphics.Font.Font__Lorg_eclipse_swt_graphics_Device_2Ljava_lang_String_2II, [display, fontFamily, fontSize, style]));
    text.setFont__Lorg_eclipse_swt_graphics_Font_2(font);
  }
}
}
