/*******************************************************************************
 * Copyright (c) 2000, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.examples.controlexample;


import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SimpleControlExample {
	//private static ResourceBundle resourceBundle =ResourceBundle.getBundle("examples_control"); //$NON-NLS-1$
	private ShellTab shellTab;
	private TabFolder tabFolder;
	private Tab [] tabs;
	Image images[];

	static final int ciClosedFolder = 0, ciOpenFolder = 1, ciTarget = 2, ciBackground = 3, ciParentBackground = 4;
	static final String[] imageLocations = {
		"closedFolder.gif", 			//$NON-NLS-1$
		"openFolder.gif", 				//$NON-NLS-1$
		"target.gif", 					//$NON-NLS-1$
		"backgroundImage.png", 			//$NON-NLS-1$
		"parentBackgroundImage.png"}; 	//$NON-NLS-1$
	static final int[] imageTypes = {
		SWT.ICON,
		SWT.ICON,
		SWT.ICON,
		SWT.BITMAP,
		SWT.BITMAP};

	boolean startup = true;

	/**
	 * Creates an instance of a ControlExample embedded inside
	 * the supplied parent Composite.
	 * 
	 * @param parent the container of the example
	 */
	public SimpleControlExample(Composite parent) {
		//initResources();
		tabFolder = new TabFolder (parent, SWT.NONE);
		
		TabItem item = new TabItem (tabFolder, SWT.NONE);
		item.setControl(createButtonTab(tabFolder));
	    item.setText ("Buttons");
		   
		item = new TabItem (tabFolder, SWT.NONE);
		item.setControl(createTreeTab(tabFolder));
	    item.setText ("Tree");
	    
	    item = new TabItem (tabFolder, SWT.NONE);
		item.setControl(createLabelTab(tabFolder));
	    item.setText ("Label");
	    
	    item = new TabItem (tabFolder, SWT.NONE);
		item.setControl(createMenuTab(tabFolder,(Decorations)parent));
	    item.setText ("Menu");
	    
	    item = new TabItem (tabFolder, SWT.NONE);
		item.setControl(createLayoutTab(tabFolder));
	    item.setText ("Layout");
	    
	    item = new TabItem (tabFolder, SWT.NONE);
		item.setControl(createShellTab(tabFolder));
	    item.setText ("Shell");
		   
	
	}

	Composite createButtonTab(Composite parent) {
		
		Composite composite = new Composite(parent, SWT.None);
		composite.setLayout(new FillLayout());
		Group group= new Group(composite, SWT.None);
		group.setLayout(new RowLayout());
		
		Button b = new Button(group, SWT.PUSH);
		b.setText("Push button");
		
		Button b2 = new Button(group, SWT.PUSH);
		b2.setText("Push button 2");
		
		
		Button b3 = new Button(group, SWT.PUSH);
		b3.setText("Push button 3");
		
		
		Group group1 = new Group(composite, SWT.None);
		group1.setLayout(new RowLayout());
		
		final Button c = new Button(group1, SWT.CHECK);
		c.setText("Check button");
		final Button c1 = new Button(group1, SWT.CHECK);
		c1.setText("Check button");
		final Button c2 = new Button(group1, SWT.CHECK);
		c2.setText("Check button");
		

		Group composite3= new Group(composite, SWT.None);
		composite3.setLayout(new RowLayout());
		final Button r = new Button(composite3, SWT.RADIO);
		r.setText("Radio button");
		Button r2 = new Button(composite3, SWT.RADIO);
		r2.setText("Radio button2");
		
		
		Group composite4 = new Group(composite, SWT.None);
		composite4.setLayout(new FillLayout());
		final Text text = new Text(composite4, SWT.MULTI);
		
		b.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				text.setText("Push button selected! " + e.detail + " " + e.time +  " " + e.x + " " +  e.y);
		}});
		
		c.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				text.setText("CheckBox button checked: " + c.getSelection());
		}});
		
		r.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				text.setText("Radio1 button checked: " + r.getSelection());
		}});
		
		r2.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				text.setText("Radio1 button checked: " + r.getSelection());
		}});
		
		return composite;
	}
	
	Composite createTreeTab(Composite parent) {
		
		Composite composite = new Composite(parent, SWT.None);
		composite.setLayout(new FillLayout());
		final Tree tree = new Tree (composite, SWT.BORDER);
		TreeItem iItem0 = new TreeItem (tree, 0);
		iItem0.setText ("TreeItem (0)");
			TreeItem iItem00 = new TreeItem (iItem0, 0);
			iItem00.setText ("TreeItem (00)");
				TreeItem iItem000 = new TreeItem (iItem00, 0);
				iItem000.setText ("TreeItem (000)");
				TreeItem iItem001 = new TreeItem (iItem00, 0);
				iItem001.setText ("TreeItem (001)");
					TreeItem iItem0010 = new TreeItem (iItem001, 0);
					iItem0010.setText ("TreeItem (0010)");
					TreeItem iItem0011 = new TreeItem (iItem001, 0);
					iItem0011.setText ("TreeItem (0011)");
						TreeItem iItem00110 = new TreeItem (iItem0011, 0);
						iItem00110.setText ("TreeItem (00110)");
					TreeItem iItem0012 = new TreeItem (iItem001, 0);
					iItem0012.setText ("TreeItem (0012)");
				TreeItem iItem002 = new TreeItem (iItem00, 0);
				iItem002.setText ("TreeItem (002)");
		TreeItem iItem1 = new TreeItem (tree, 0);
		iItem1.setText ("TreeItem (1)");
			TreeItem iItem10 = new TreeItem (iItem1, 0);
			iItem10.setText ("TreeItem (10)");
				TreeItem iItem100 = new TreeItem (iItem10, 0);
				iItem100.setText ("TreeItem (100)");
					TreeItem iItem1000 = new TreeItem (iItem100, 0);
					iItem1000.setText ("TreeItem (1000)");
					TreeItem iItem1001 = new TreeItem (iItem100, 0);
					iItem1001.setText ("TreeItem (1001)");
						TreeItem iItem10010 = new TreeItem (iItem1001, 0);
						iItem10010.setText ("TreeItem (10010)");
						TreeItem iItem10011 = new TreeItem (iItem1001, 0);
						iItem10011.setText ("TreeItem (10010)");
					TreeItem iItem1002 = new TreeItem (iItem100, 0);
					iItem1002.setText ("TreeItem (1002)");
				TreeItem iItem101 = new TreeItem (iItem10, 0);
				iItem101.setText ("TreeItem (101)");
				TreeItem iItem102 = new TreeItem (iItem10, 0);
				iItem102.setText ("TreeItem (102) Events!");
				
				Group composite4 = new Group(composite, SWT.None);
				composite4.setLayout(new FillLayout());
				final Text text = new Text(composite4, SWT.MULTI);
				
				iItem102.addListener (SWT.MouseDown, new Listener () {
					public void handleEvent (Event e) {
						String current = text.getText();
						text.setText(current + " Item Selected");
					}
				});
				iItem102.addListener (SWT.FocusIn, new Listener () {
					public void handleEvent (Event e) {
						String current = text.getText();
						text.setText(current + " Item FocusIn");
					}
				});
				iItem102.addListener (SWT.FocusOut, new Listener () {
					public void handleEvent (Event e) {
						String current = text.getText();
						text.setText(current + " Item FocusOut");
					}
				});

		return composite;
	}

	Composite createLabelTab(Composite parent) {
		Composite composite = new Composite(parent, SWT.None);
		composite.setLayout(new FillLayout());
		
		final Label label = new Label(composite,SWT.BORDER);
		label.setBounds(10, 30, 200, 200);
		label.setText("Label Text 1, akja ahas adkhas asjdhas");
		label.setAlignment(SWT.RIGHT);
		
		final Label label2 = new Label(composite,SWT.BORDER | SWT.WRAP);
		label2.setBounds(60, 60, 300, 300);
		label2.setText("Label Text 2 ajka aoabasbasopiasusa asdjklas asdhkl akjshask audaskjas asdoiasiuas asoiuasd ");
		label2.setAlignment(SWT.CENTER);
		
		Group composite4 = new Group(composite, SWT.None);
		composite4.setLayout(new FillLayout());
		final Text text = new Text(composite4, SWT.MULTI);

		label.addListener(SWT.MouseDown, new Listener(){
			public void handleEvent(Event event) {
				text.setText("Label text copy: "+label.getText());
			}
		});
		label2.addListener(SWT.MouseDown, new Listener(){
			public void handleEvent(Event event) {
				text.setText("Label text copy: "+label2.getText());
			}
		});
		return composite;
	}

	Composite createMenuTab(Composite parent, Decorations shell) {
		Composite composite = new Composite(parent, SWT.None);
		composite.setLayout(new FillLayout());
		
		Menu menu = new Menu (shell, SWT.POP_UP);
		MenuItem item1 = new MenuItem (menu, SWT.PUSH);
		item1.setText ("Push Item 0");
		MenuItem item2 = new MenuItem (menu, SWT.CASCADE);
		item2.setText ("Cascade Item 1");
		
		Menu subMenu = new Menu (menu);
		item2.setMenu (subMenu);
		MenuItem subItem2 = new MenuItem (subMenu, SWT.CASCADE);
		subItem2.setText ("Cascade subItem 10");
		
		final Text text = new Text(composite, SWT.MULTI);
		
		subItem2.addListener (SWT.MouseDown, new Listener () {
			public void handleEvent (Event e) {
				text.setText("Cascade subItem 10 Selected");
			}
		});
		subItem2.addListener (SWT.FocusIn, new Listener () {
			public void handleEvent (Event e) {
				text.setText("Cascade subItem 10 FocusIn");
			}
		});
		subItem2.addListener (SWT.FocusOut, new Listener () {
			public void handleEvent (Event e) {
				text.setText("Cascade subItem 10 FocusOut");
			}
		});
		MenuItem subItem1 = new MenuItem (subMenu, SWT.PUSH);
		subItem1.setText ("Push subItem 11");
		subItem1.addListener (SWT.MouseDown, new Listener () {
			public void handleEvent (Event e) {
				text.setText("Push subItem 11 Selected");
			}
		});
			Menu subSubMenu = new Menu (subItem2);
			subItem2.setMenu (subSubMenu);
				MenuItem subSubItem1 = new MenuItem (subSubMenu, SWT.PUSH);
				subSubItem1.setText ("Push subSubItem 100");
				
				
				MenuItem subSubItem2 = new MenuItem (subSubMenu, SWT.PUSH);
				subSubItem2.setText ("Cascade subSubItem 101");
		
		return composite;
	}
	
	Composite createLayoutTab(Composite parent) {
		final Composite composite = new Composite(parent, SWT.None);
		composite.setLayout(new GridLayout(4,false));
			
			/*final Composite composite1 = new Composite(composite, SWT.None);
			composite1.setLayout(new FillLayout());
			new Button(composite1, SWT.PUSH).setText("Button1");
			new Button(composite1, SWT.PUSH).setText("Button2");
			new Button(composite1, SWT.PUSH).setText("Button3");
			
			final Composite composite2 = new Composite(composite, SWT.None);
			composite2.setLayout(new RowLayout());
			new Button(composite2, SWT.PUSH).setText("Button1");
			new Button(composite2, SWT.PUSH).setText("Button2");
			new Button(composite2, SWT.PUSH).setText("Button3");
			
			final Composite composite3 = new Composite(composite, SWT.None);
			composite3.setLayout(new GridLayout(4,false));
			new Button(composite3, SWT.PUSH).setText("Button1");
			new Button(composite3, SWT.PUSH).setText("Button2");
			new Button(composite3, SWT.PUSH).setText("Button3");*/
			
			Button b = new Button(composite, SWT.PUSH);
			b.setText("LEFT, TOP");
			b.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, true, true, 1, 1));
			b = new Button(composite, SWT.PUSH);
			b.setText("LEFT, CENTER");
			b.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, true, 1, 1));
			b = new Button(composite, SWT.PUSH);
			b.setText("LEFT, BOTTOM");
			b.setLayoutData(new GridData(SWT.LEFT, SWT.BOTTOM, true, true, 1, 1));
			b = new Button(composite, SWT.PUSH);
			b.setText("LEFT, FILL");
			b.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, true, true, 1, 1));
			b = new Button(composite, SWT.PUSH);
			b.setText("CENTER, TOP");
			b.setLayoutData(new GridData(SWT.CENTER, SWT.TOP, true, true, 1, 1));
			b = new Button(composite, SWT.PUSH);
			b.setText("CENTER, CENTER");
			b.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, true, true, 1, 1));
			b = new Button(composite, SWT.PUSH);
			b.setText("CENTER, BOTTOM");
			b.setLayoutData(new GridData(SWT.CENTER, SWT.BOTTOM, true, true, 1, 1));
			b = new Button(composite, SWT.PUSH);
			b.setText("CENTER, FILL");
			b.setLayoutData(new GridData(SWT.CENTER, SWT.FILL, true, true, 1, 1));
			b = new Button(composite, SWT.PUSH);
			b.setText("RIGHT, TOP");
			b.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, true, true, 1, 1));
			b = new Button(composite, SWT.PUSH);
			b.setText("RIGHT, CENTER");
			b.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, true, 1, 1));
			b = new Button(composite, SWT.PUSH);
			b.setText("RIGHT, BOTTOM");
			b.setLayoutData(new GridData(SWT.RIGHT, SWT.BOTTOM, true, true, 1, 1));
			b = new Button(composite, SWT.PUSH);
			b.setText("RIGHT, FILL");
			b.setLayoutData(new GridData(SWT.RIGHT, SWT.FILL, true, true, 1, 1));
			b = new Button(composite, SWT.PUSH);
			b.setText("FILL, TOP");
			b.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, true, 1, 1));
			b = new Button(composite, SWT.PUSH);
			b.setText("FILL, CENTER");
			b.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, true, 1, 1));
			b = new Button(composite, SWT.PUSH);
			b.setText("FILL, BOTTOM");
			b.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1));
			b = new Button(composite, SWT.PUSH);
			b.setText("FILL, FILL");
			b.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
			
		
		return composite;
	}
	
	Composite createShellTab(Composite parent) {
		final Composite composite = new Composite(parent, SWT.None);
//		composite.setLayout(new FillLayout());
		final Shell[] openShells = new Shell[100];
		final Shell parentShell = parent.getShell();
		final Button btn = new Button(composite, SWT.PUSH);
		btn.setText("Open Shell");
		
		Group composite4 = new Group(composite, SWT.None);
		composite4.setLayout(new FillLayout());
		final Text text = new Text(composite4, SWT.MULTI);
		
		btn.addListener(SWT.MouseDown, new Listener(){
			public void handleEvent(Event event) {
				 Shell shell = new Shell(parentShell);
				 shell.setBounds(100,100,300,200);
				 openShells[0] = shell;
			}
		});
		btn.setBounds(10, 10, 100, 30);
	
		
		return composite;
	}
	/**
	 * Disposes of all resources associated with a particular
	 * instance of the ControlExample.
	 */	
	public void dispose() {
		/*
		 * Destroy any shells that may have been created
		 * by the Shells tab.  When a shell is disposed,
		 * all child shells are also disposed.  Therefore
		 * it is necessary to check for disposed shells
		 * in the shells list to avoid disposing a shell
		 * twice.
		 */
		if (shellTab != null) shellTab.closeAllShells ();
		shellTab = null;
		tabFolder = null;
		freeResources();
	}

	/**
	 * Frees the resources
	 */
	void freeResources() {
		if (images != null) {
			for (int i = 0; i < images.length; ++i) {
				final Image image = images[i];
				if (image != null) image.dispose();
			}
			images = null;
		}
	}
	
	/**
	 * Gets a string from the resource bundle.
	 * We don't want to crash because of a missing String.
	 * Returns the key if not found.
	 */
	static String getResourceString(String key) {
	/*	try {
			return resourceBundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		} catch (NullPointerException e) {*/
			return "!" + key + "!"; //$NON-NLS-1$ //$NON-NLS-2$
		//}			
	}

	/**
	 * Gets a string from the resource bundle and binds it
	 * with the given arguments. If the key is not found,
	 * return the key.
	 */
	static String getResourceString(String key, Object[] args) {
	/*	try {
			return MessageFormat.format(getResourceString(key), args);
		} catch (MissingResourceException e) {
			return key;
		} catch (NullPointerException e) {*/
			return "!" + key + "!"; //$NON-NLS-1$ //$NON-NLS-2$
		//}
	}

	/**
	 * Loads the resources
	 */
/*	void initResources() {
		final Class clazz = ControlExample.class;
		if (resourceBundle != null) {
			try {
				if (images == null) {
					images = new Image[imageLocations.length];
					
					for (int i = 0; i < imageLocations.length; ++i) {
						InputStream sourceStream = clazz.getResourceAsStream(imageLocations[i]);
						ImageData source = new ImageData(sourceStream);
						if (imageTypes[i] == SWT.ICON) {
							ImageData mask = source.getTransparencyMask();
							images[i] = new Image(null, source, mask);
						} else {
							images[i] = new Image(null, source);
						}
						try {
							sourceStream.close();
						} catch (IOException e) {
							e.printStackTrace();
						}
					}
				}
				return;
			} catch (Throwable t) {
			}
		}
		String error = (resourceBundle != null) ?
			getResourceString("error.CouldNotLoadResources") :
			"Unable to load resources"; //$NON-NLS-1$
		freeResources();
		throw new RuntimeException(error);
	}*/

	/**
	 * Invokes as a standalone program.
	 */
	public static void main(String[] args) {
		Display display = new Display();
		Shell shell = new Shell(display, SWT.SHELL_TRIM);
		shell.setLayout(new FillLayout());
		
		SimpleControlExample instance = new SimpleControlExample(shell);
//		shell.setText(getResourceString("window.title"));
//		setShellSize(instance, shell);
		shell.open();
		display.displayRun();
//		while (! shell.isDisposed()) {
//			if (! display.readAndDispatch()) display.sleep();
//		}
//		instance.dispose();
//		display.dispose();	}
	}
	
	/**
	 * Grabs input focus.
	 */
	public void setFocus() {
		tabFolder.setFocus();
	}
	
	/**
	 * Sets the size of the shell to it's "packed" size,
	 * unless that makes it larger than the monitor it is being displayed on,
	 * in which case just set the shell size to be slightly smaller than the monitor.
	 */
	static void setShellSize(SimpleControlExample instance, Shell shell) {
		Point size = shell.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		Rectangle monitorArea = shell.getMonitor().getClientArea();
		/* Workaround: if the tab folder is wider than the screen,
		 * carbon clips instead of somehow scrolling the tab items.
		 * We try to recover some width by using shorter tab names. */
		if (size.x > monitorArea.width && SWT.getPlatform().equals("carbon")) {
			TabItem [] tabItems = instance.tabFolder.getItems();
			for (int i=0; i<tabItems.length; i++) {
				tabItems[i].setText (instance.tabs [i].getShortTabText ());
			}
			size = shell.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		}
		shell.setSize(Math.min(size.x, monitorArea.width), Math.min(size.y, monitorArea.height));
	}
}

