/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.e4.examples.controlexample;

import org.eclipse.swt.SWT;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class Example {

public Example() {
	final Display display = new Display();
	Shell shell = new Shell(display);
	shell.setText("ControlExample");
	shell.setLayout(new FillLayout());
	new ControlExample(shell);
	shell.open();
	shell.addListener(SWT.Dispose, new Listener() {
		public void handleEvent(Event event) {
			display.dispose();
		}
	});
}

static boolean isWeb() {
	if ("flex".equals(SWT.getPlatform())) return true;
	if ("dojo".equals(SWT.getPlatform())) return true;
	return false;	
}

public static void main(String[] args) {
	new Example();
	if (isWeb()) return;
	Display display = Display.getCurrent();
	while (!display.isDisposed()) {
		if (!display.readAndDispatch()) display.sleep();
	}
}
}
