/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.e4.examples.flickrviewer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.*;

public class FlickrMain {

	public final static String START_PHOTO = "http://farm1.static.flickr.com/211/484174432_5e08b6b760.jpg";
	public final static String START_TAG = "North Carolina"; //"foz2007"
	
public FlickrMain() {
	final Display display = new Display();
	Shell shell = new Shell(display, isWeb() ? SWT.NO_TRIM : SWT.SHELL_TRIM);
	FlickrViewer flickrViewer = new FlickrViewer(shell, SWT.NONE);
	flickrViewer.setStartPhoto(START_PHOTO);
	flickrViewer.search(START_TAG, 50);
	shell.open();
	
	shell.addListener(SWT.Dispose, new Listener() {
		public void handleEvent(Event event) {
			display.dispose();
		}
	});
}

static boolean isWeb() {
	if ("flex".equals(SWT.getPlatform())) return true;
	if ("dojo".equals(SWT.getPlatform())) return true;
	return false;	
}
	
public static void main(String[] args) {
	new FlickrMain();
	if (isWeb()) return;
	Display display = Display.getCurrent();
	while (!display.isDisposed()) {
		if (!display.readAndDispatch()) display.sleep();
	}
}
}
