/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.e4.examples.flickrviewer;

import org.eclipse.swt.net.HttpRequest;
import org.eclipse.swt.widgets.Listener;

public class FlickrRequest {

	public static final String AUTH_ENDPOINT = "http://api.flickr.com/services/auth/";
	public static final String REST_ENDPOINT = "http://api.flickr.com/services/rest/";
	public static final String API_KEY = "577d60a5a34de21b946f807e06d2744d";
	
	String method;
	String[] parameters;
	String format = "e4x";
	
FlickrRequest(String method, String[] parameters) {
	this.method = method;
	this.parameters = parameters;
}

public void send(Listener listener) {
	HttpRequest httpRequest = new HttpRequest();
	String url = REST_ENDPOINT + generateQuery();
	httpRequest.setURL(url);
	httpRequest.setUseProxy(false);
	httpRequest.setFormat(format);
	httpRequest.addListener(listener);
	httpRequest.invoke();
}

String generateQuery () {
	StringBuffer buffer = new StringBuffer("?");
	buffer.append("api_key=");
	buffer.append(API_KEY);
	buffer.append("&");
	buffer.append("method=");
	buffer.append(method);
	buffer.append("&");
	for (int i = 0; i < parameters.length; i+=2) {
		buffer.append(parameters[i]);
		buffer.append("=");
		buffer.append(parameters[i + 1]);
		buffer.append("&");
	}
	return buffer.toString();
}
}
