/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.e4.examples.flickrviewer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.net.*;
import org.eclipse.swt.widgets.*;

public class FlickrViewer extends Composite {
	Dock dock;
	View view;
	SearchPane searchPane;
	String startPhoto;
	
public FlickrViewer(Composite parent, int style) {
	super(parent, style);
	create();
} 
	
void create () {
	final Composite parent = getParent();
	final Composite composite = this; 
	composite.setLayout(new GridLayout(1, false));
	view = new View(composite, SWT.NONE);
	view.setLayoutData(new GridData(GridData.FILL_BOTH));
	dock = new Dock (composite, SWT.NONE);
	dock.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	dock.setThumbSize(new Point(50, 37));
	dock.setZoomSize(new Point(100, 74));
	
	Listener listener2 = new Listener() {
		public void handleEvent(Event event) {
			Listener listener3 = new Listener() {
				public void handleEvent(Event event1) {
					PhotoInfo info = (PhotoInfo)event1.data;
					Image image = info.getImage(PhotoInfo.SIZE_MEDIUM);
					view.setImage (image);
					view.setDescription(info.title);
				}
			};
			PhotoInfo info = (PhotoInfo)event.data;
			info.getImage(PhotoInfo.SIZE_MEDIUM, listener3);
		}
	};
	dock.addListener(SWT.Selection, listener2);
	searchPane = new SearchPane (parent, SWT.NONE);
	searchPane.addListener(SWT.Selection, new Listener() {
		public void handleEvent(Event event) {
			String string = searchPane.getText();
			if (string.length() > 0) {
				view.setImage(null);
				view.setDescription(null);
				dock.removeAll();
				//TODO dispose PhotoInfo
				search(string, searchPane.getCount());
			}
			composite.setEnabled(true);
		}
	});
	searchPane.moveAbove(null);
	
	Link searchButton = new Link (composite, SWT.NONE);
	searchButton.setText("<A>New search</A>");
	searchButton.setLayoutData(new GridData (SWT.CENTER, SWT.CENTER, true, false));
	searchButton.addListener(SWT.Selection, new Listener() {
		public void handleEvent(Event event) {
			composite.setEnabled(false);
			searchPane.show();
		}
	});
	
	parent.addListener(SWT.Resize, new Listener () {
		public void handleEvent(Event event) {
			Rectangle clientArea = parent.getClientArea();
			composite.setBounds(clientArea);
			searchPane.setLocation(0, clientArea.height);
		}
	});
	parent.addListener(SWT.Resize, new Listener () {
		public void handleEvent(Event event) {
			parent.removeListener(SWT.Resize, this);
			if (startPhoto != null) {
				FlickrUtil.setImage(new Listener() {
					public void handleEvent(Event event) {
						Image image = (Image)event.data;
						view.setImage(image);
						view.setDescription("Flickr Viewer");
						view.setDescriptionVisible(true);
					};
				}, startPhoto);
			}
		}
	});
}

public void search (String tag, int count) {
	Listener listener0 = new Listener() {
		public void handleEvent(Event event) {
			Listener listener1 = new Listener() {
				public void handleEvent(Event event1) {
					PhotoInfo info = (PhotoInfo)event1.data;
					Image image = info.getImage(PhotoInfo.SIZE_THUMBNAIL);
					dock.add(image, info.description, info);
				}
			};
			PhotoInfo[] photos = getPhotosInfo(event.data);
			for (int i = 0; i < photos.length; i++) {
				PhotoInfo photoInfo = photos[i];
				photoInfo.getImage(PhotoInfo.SIZE_THUMBNAIL, listener1);
			}
		}
	}; 
	String[] parameters = {"tags", tag, "per_page", String.valueOf(count)};
	String method = "flickr.photos.search";
	FlickrRequest request = new FlickrRequest(method, parameters);
	request.send(listener0);
}

public void setStartPhoto (String photo) {
	startPhoto = photo;
}

PhotoInfo[] getPhotosInfo(Object object) {
	String[] photos = FlickrUtil.getPhotosInfo(object);
	PhotoInfo[] infos = new PhotoInfo[photos.length / 3];
	for (int i = 0, j = 0; i < infos.length; i++) {
		PhotoInfo info = infos[i] = new PhotoInfo();
		info.title = photos[j++];
		info.id = photos[j++];
		info.secret = photos[j++];
	}
	return infos;
}

}
