/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.e4.examples.flickrviewer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.animation.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;

public class ImageCanvas extends Canvas {
	Image image;
	PropertyAnimation animation;
	
public ImageCanvas(Composite parent, int style) {
	super(parent, style);
	animation = new LinearPropertyAnimation();
	animation.setProperty("size");
	animation.setTarget(this);
	
	addListener(SWT.Paint, new Listener() {
		public void handleEvent(Event event) {
			if (image == null) return;
			GC gc = event.gc;
			Rectangle bounds = image.getBounds();
			Rectangle rect = getClientArea();
			gc.drawImage(image, 0, 0, bounds.width, bounds.height, rect.x, rect.y, rect.width, rect.height);
		}
	});
}

public void setImage(Image image) {
	this.image = image;
}

public void zoom (Point size, long duration) {
	animation.stop();
	animation.setDuration(duration);
	animation.setTo(size);
	animation.start(this);
}

}
