/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.e4.examples.flickrviewer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.net.FlickrUtil;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class PhotoInfo{
	public static final String SIZE_SQUARE = "Square";
	public static final String SIZE_THUMBNAIL = "Thumbnail";
	public static final String SIZE_SMALL = "Small";
	public static final String SIZE_MEDIUM = "Medium";
	public static final String SIZE_LARGE = "Large";
	
	public String title, description;
	public String id;
	public String secret;
	
	Hashtable urls;
	Hashtable images;
	Hashtable listeners;
	
	public PhotoInfo() {
		listeners = new Hashtable();
		images = new Hashtable();
	}
	
	public Image getImage(String size) {
		return (Image)images.get(size);
	}
	
	public void getImage(String size, Listener listener) {
		Vector list = (Vector)listeners.get(size);
		if (list == null) {
			list = new Vector();
			listeners.put(size, list);
		}
		list.addElement(listener);
		runListeners();
	}
	
	public void dispose() {
		if (images == null) return;
		Enumeration enumeration = images.elements();
		while (enumeration.hasMoreElements()) {
			Image image = (Image)enumeration.nextElement();
			image.dispose();
		}
		listeners = null;
		images = null;
		urls = null;
	}
	
	void runListeners() {
		if (urls == null) {
			loadUrls();
			return;
		}
		Enumeration sizes = listeners.keys();
		while (sizes.hasMoreElements()) {
			String size = (String)sizes.nextElement();
			Image image = (Image)images.get(size);
			if (image == null) {
				loadImage(size);
				continue;
			}
			Vector list = (Vector)listeners.get(size);
			if (list != null) {
				Event event = new Event();
				event.data = this;
				for (int i=0; i<list.size(); i++) {
					Listener listener = (Listener)list.remove(0);
					listener.handleEvent(event);
				}
			}
		}
	}
	
	void loadImage(final String size) {
		String url = (String)urls.get(size);
		Listener listener = new Listener() {
			public void handleEvent(Event event) {
				images.put(size, event.data);
				runListeners();
			}	
		};
		FlickrUtil.setImage(listener, url);
	}
	
	void loadUrls() {
		urls = new Hashtable();
		Listener listener = new Listener() {
			public void handleEvent(Event event) {
				Object xml = event.data;
				urls.put(SIZE_SQUARE, FlickrUtil.getPhotoURL(xml, SIZE_SQUARE));
				urls.put(SIZE_THUMBNAIL, FlickrUtil.getPhotoURL(xml, SIZE_THUMBNAIL));
				urls.put(SIZE_SMALL, FlickrUtil.getPhotoURL(xml, SIZE_SMALL));
				urls.put(SIZE_MEDIUM, FlickrUtil.getPhotoURL(xml, SIZE_MEDIUM));
				urls.put(SIZE_LARGE, FlickrUtil.getPhotoURL(xml, SIZE_LARGE));
				runListeners();
			}
		};
		String[] parameters = {"photo_id", id, "secret", secret};
		String method = "flickr.photos.getSizes";
		FlickrRequest request = new FlickrRequest(method, parameters);
		request.send(listener);
	}
	
}
