/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.e4.examples.flickrviewer;

import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.animation.*;

public class SearchPane extends Composite {
	static long DURATION = 400;
	Combo combo;
	Spinner spinner;
	PropertyAnimation slide;
	
public SearchPane(Composite parent, int style) {
	super(parent, style);
	Display display = getDisplay();
	setBackground(display.getSystemColor(SWT.COLOR_GRAY));
	setAlpha(180);
	GridLayout layout = new GridLayout(4, false);
	layout.marginHeight = layout.marginWidth = 20;
	setLayout(layout);
	slide = new LinearPropertyAnimation();
	slide.setTarget(this);
	slide.setProperty("location");
	slide.setDuration(DURATION);
	
	Label label0 = new Label (this, SWT.NONE);
	label0.setText("Search:");
	combo = new Combo (this, SWT.DROP_DOWN);
	combo.setLayoutData(new GridData(160, SWT.DEFAULT));
	combo.setAlpha(255);
	Label label1 = new Label (this, SWT.NONE);
	label1.setText("Count:");
	spinner = new Spinner (this, SWT.NONE);
	spinner.setSelection(20);
	spinner.setAlpha(255);
	
	Listener listener = new Listener() {
		public void handleEvent(Event event) {
			String string = combo.getText();
			if (combo.indexOf(string) == -1) combo.add(string);
			notifyListeners(SWT.Selection, new Event());
			hide();
		}
	};
	spinner.addListener(SWT.DefaultSelection, listener);
	combo.addListener(SWT.DefaultSelection, listener);
	combo.addListener(SWT.KeyDown, new Listener () {
		public void handleEvent(Event event) {
			if (event.keyCode == SWT.ESC) {
				combo.setText("");
				notifyListeners(SWT.Selection, new Event());
				hide();
			}
		}
	});
	pack();
}

public void hide() {
	slide.stop();
	Rectangle clientArea = getParent().getClientArea();
	Rectangle bounds = getBounds();

	slide.setFrom(new Point(bounds.x, bounds.y));
	slide.setTo(new Point(bounds.x, clientArea.height));
	slide.start(SearchPane.this);
}

public void show() {
	slide.stop();
	Rectangle clientArea = getParent().getClientArea();
	Rectangle bounds = getBounds();
	combo.setFocus();
	int x = (clientArea.width - bounds.width) / 2;
	int y = (clientArea.height - bounds.height) / 2;
	
	slide.setFrom(new Point(x, clientArea.height));
	slide.setTo(new Point(x, y));
	slide.start(this);
}

public String getText () {
	return combo.getText();
}

public int getCount () {
	return spinner.getSelection();
}

}
