/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.e4.examples.flickrviewer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.animation.*;
import org.eclipse.swt.effects.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class View extends Composite {
	static final int FADE_TIME = 500;
	static final int BORDER = 4;
	
	Label current, view, overlay, description;
	Composite descriptionPanel;
	Image image;
		
public View (Composite parent, int style) {
	super (parent, style);
	Display display = getDisplay();
	view = current = new Label(this, SWT.NONE);
	overlay = new Label(this, SWT.NONE);
	overlay.setAlpha(0);
	descriptionPanel = new Composite(this, SWT.NONE);
	descriptionPanel.setLayout(new GridLayout(1, false));
	descriptionPanel.setBackground(display.getSystemColor(SWT.COLOR_BLACK));
	descriptionPanel.setAlpha(50);
	description = new Label(descriptionPanel, SWT.NONE);
	description.setForeground(display.getSystemColor(SWT.COLOR_WHITE));
	description.setFont(new Font(display, "Verdana", 14, SWT.NORMAL));
	description.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, true, true));
	descriptionPanel.moveAbove(null);
	
	DropShadowEffect effect = new DropShadowEffect();
	effect.setDistance(10);
	effect.setColor(new Color(display, 102, 153, 204));
	view.setEffect(effect);
	overlay.setEffect(effect);
	
	Listener enterListener = new Listener() {
		public void handleEvent(Event event) {
			setDescriptionVisible(true);
		}
	};
	overlay.addListener(SWT.MouseEnter, enterListener);
	view.addListener(SWT.MouseEnter, enterListener);
	addListener(SWT.Resize, new Listener() {
		public void handleEvent(Event event) {
			Rectangle bounds = current.getBounds();
			Rectangle parentBounds = getBounds(); 
			int x = (parentBounds.width - bounds.width) / 2;
			int y = (parentBounds.height - bounds.height) / 2;
			current.setLocation(x, y);
			setDescriptionVisible(false);
		}
	});
}

public void setDescriptionVisible(boolean visible) {
	if (description.getText().length() == 0) return;
	Rectangle bounds = current.getBounds();
	if (visible == (descriptionPanel.getSize().y != 0)) return;
	if (visible) {
		if (descriptionPanel.getSize().y > 0 ) return;
		descriptionPanel.setBounds(bounds.x + BORDER, Math.max(BORDER, bounds.y + BORDER), bounds.width - BORDER * 2, 0);
		
		PropertyAnimation slideIn = new LinearPropertyAnimation();
		slideIn.setTarget(descriptionPanel);
		slideIn.setProperty("height");
		slideIn.setFrom(new Integer(0));
		slideIn.setTo(new Integer(50));
		slideIn.setDuration(400);
		slideIn.start(descriptionPanel);
		getDisplay().timerExec(3000, new Runnable() {
			public void run() {
				setDescriptionVisible(false);
			}
		});
	} else {
		if (descriptionPanel.getSize().y < 50) return;
		descriptionPanel.setBounds(bounds.x + BORDER, Math.max(BORDER, bounds.y + BORDER), bounds.width - BORDER * 2, 0);
		
		PropertyAnimation slideOut = new LinearPropertyAnimation();
		slideOut.setTarget(descriptionPanel);
		slideOut.setProperty("height");
		slideOut.setFrom(new Integer(50));
		slideOut.setTo(new Integer(0));
		slideOut.setDuration(400);
		slideOut.start(descriptionPanel);
	}
}

public void setDescription(String string) {
	description.setText(string != null ? string : "");
	int height = descriptionPanel.getSize().y; 
	if (height > 0 ) {
		Rectangle bounds = current.getBounds();
		descriptionPanel.setBounds(bounds.x + BORDER, Math.max(BORDER, bounds.y + BORDER), bounds.width - BORDER * 2, height);
		descriptionPanel.layout();
	}
}

public void setImage (Image image) {
	if (image == this.image) return;
	this.image = image;
	
	Label topLabel = current;
	final Label bottomLabel = topLabel == overlay ? view : overlay;
	
	PropertyAnimation fadeOut = new LinearPropertyAnimation();
	fadeOut.setTarget(topLabel);
	fadeOut.setProperty("alpha");
	fadeOut.setTo(new Integer(0));
	fadeOut.setDuration(FADE_TIME);
	fadeOut.start(topLabel);

	if (image != null) {
		Rectangle bounds = image.getBounds();
		Rectangle parentBounds = getBounds(); 
		int x = (parentBounds.width - bounds.width) / 2;
		int y = (parentBounds.height - bounds.height) / 2;
		bottomLabel.setBounds(x, y, bounds.width, bounds.height);
	
		bottomLabel.setImage(image);
		PropertyAnimation fadeIn = new LinearPropertyAnimation();
		fadeIn.setTarget(bottomLabel);
		fadeIn.setProperty("alpha");
		fadeIn.setTo(new Integer(255));
		fadeIn.setDuration(FADE_TIME);
		fadeIn.start(bottomLabel);
		current = bottomLabel;
	}
}
}
