/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.e4.examples.st;

import java.util.Hashtable;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.*;


public class STDemo {
	Display display;
	StyledText text;
	Hashtable stylesTable;
	String verifyCB;
	JavaLineStyler styler;

public STDemo () {
}

public void go() {
	stylesTable = new Hashtable();
	display = new Display();
	final Shell shell = new Shell(display, SWT.NO_TRIM);
	shell.setText("Demo");
	FillLayout layout = new FillLayout();
	shell.setLayout(layout);
	text = new StyledText(shell, SWT.V_SCROLL | SWT.H_SCROLL);
	text.addListener(SWT.Verify, new Listener() {
		public void handleEvent(Event event) {
			callOut(verifyCB, event.text, event.start, event.end);
		}
	});
	shell.open();

	shell.addListener(SWT.Dispose, new Listener() {
		public void handleEvent(Event event) {
			display.dispose();
		}
	});
}


static boolean isWeb() {
	if ("flex".equals(SWT.getPlatform())) return true;
	if ("dojo".equals(SWT.getPlatform())) return true;
	return false;	
}

public static void main(String[] args) {
	new STDemo ().go(); 
	if (isWeb()) return;
	Display display = Display.getCurrent();
	while (!display.isDisposed()) {
		if (!display.readAndDispatch()) display.sleep();
	}
}

//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=--=-=-=-=-

public native void callOut(String callback, String text, int start, int end) /*{
	if (callback != null) {
		import flash.external.ExternalInterface;
		ExternalInterface.call(callback, text, start, end);
	}
}*/; 

public void setJavaStyler(boolean enabled) {
	if (enabled) {
		if (styler == null) {
			styler = new JavaLineStyler();
			styler.parseBlockComments(text.getText());
			text.addLineStyleListener(styler);
		}
	} else {
		if (styler != null) {
			text.removeLineStyleListener(styler);
			styler = null;
		}
	}
	text.redraw();
}

public Color getColor(int c) {
	return new Color(display, (c & 0xFF0000) >> 16, (c & 0xFF00) >> 8, c & 0xFF);
}

public native StyleRange createStyleFromCSS(String key) /*{
	import mx.styles.StyleManager;
	import mx.styles.CSSStyleDeclaration;
	var style : StyleRange = new StyleRange();
	
	var st : CSSStyleDeclaration = StyleManager.getStyleDeclaration(key);
	if (st != null) {
		var fg : * = st.getStyle("color");
		var bg : * = st.getStyle("backgroundColor");
		var underlineColor : * = st.getStyle("underlineColor");
		var borderColor : * = st.getStyle("borderColor");
		var strikeoutColor : * = st.getStyle("strikeoutColor");
		var fontWeight : String = st.getStyle("fontWeight");
		var fontStyle : String = st.getStyle("fontStyle");
		var underlineStyle : String = st.getStyle("underlineStyle");
		var borderStyle : String = st.getStyle("borderStyle");
		var strikeoutStyle : String = st.getStyle("strikeoutStyle");
		
		
		if (underlineStyle == "single") {
			style.underline = true;
		} else if (underlineStyle == "double") {
			style.underline = true;
			style.underlineStyle = SWT.UNDERLINE_DOUBLE;
		} else if (underlineStyle == "squiggle") {
			style.underline = true;
			style.underlineStyle = SWT.UNDERLINE_SQUIGGLE;
		} else if (underlineStyle == "error") {
			style.underline = true;
			style.underlineStyle = SWT.UNDERLINE_ERROR;
		}
		if (borderStyle == "solid") {
			style.borderStyle = SWT.BORDER_SOLID;
		}
		if (strikeoutStyle == "solid") {
			style.strikeout = true;
		}
		if (fontWeight == "bold") {
			style.fontStyle = SWT.BOLD;
		}
		if (fontStyle == "italic") {
			style.fontStyle |= SWT.ITALIC;
		}
		if (fg != undefined) {
			style.foreground = getColor__I(fg);
		}
		if (bg != undefined) {
			style.background = getColor__I(bg);
		}
		if (underlineColor != undefined) {
			style.underlineColor = getColor__I(underlineColor);
		}
		if (borderColor != undefined) {
			style.borderColor = getColor__I(borderColor);
		}
		if (strikeoutColor != undefined) {
			style.strikeoutColor = getColor__I(strikeoutColor);
		}
	}
	return style;
}*/; 

public void setText(String string) {
	text.setText(string);
}

public String getText() {
	return text.getText();
}

public Point getSelection() {
	return text.getSelection();
}

public void setSelection(int start, int end) {
	text.setSelection(start, end);
}

public void addVerifyListener(String JSMethod) {
	this.verifyCB = JSMethod;
}

public void setStyleRange(int start, int length, int[] ranges, String[] styles) {
	StyleRange[] styleRanges = getStyleRanges(styles);
	text.setStyleRanges(start, length, ranges, styleRanges);
}

public void setStyleRange(int[] ranges, String[] styles) {
	StyleRange[] styleRanges = getStyleRanges(styles);
	text.setStyleRanges(ranges, styleRanges);
}

StyleRange[] getStyleRanges(String[] styles) {
	StyleRange[] styleRanges = new StyleRange[styles.length];
	for (int i = 0; i < styles.length; i++) {
		String key = styles[i];
		StyleRange style = (StyleRange)stylesTable.get(key);
		if (style == null) {
			style = createStyleFromCSS(key);
			stylesTable.put(key, style);
		}
		styleRanges[i] = style;
	}
	return styleRanges;
}

public void setForeground(int color) {
	text.setForeground(getColor(color));
}

public void setBackground(int color) {
	text.setBackground(getColor(color));
}

public int getForeground () {
	return text.getForeground().handle;
}

public int getBackground () {
	return text.getBackground().handle;
}

public Rectangle getClientArea() {
	return text.getClientArea();
}

public int getLineHeight() {
	return text.getLineHeight();
}

public void setTopIndex(int topIndex) {
	text.setTopIndex(topIndex);
}

public void setTopPixel(int topPixel) {
	text.setTopPixel(topPixel);
}

public void setFont(String fontFamily, int fontSize, String fontWeight, String fontStyle) {
	int style = SWT.NONE;
	if (fontWeight.equals("bold")) style |= SWT.BOLD;
	if (fontStyle.equals("italic")) style |= SWT.ITALIC;
	Font font = new Font(display, fontFamily, fontSize, style);
	text.setFont(font);
}
}
