package java.beans {
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.lang.Boolean__;
import java.lang.Integer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class PropertyChangeSupport {
  internal var source: Object;
  internal var allPropertyListeners: ArrayList;
  internal var propertyListeners: HashMap;
  public function PropertyChangeSupport(sourceBean: Object) {
    this.source = sourceBean;
    allPropertyListeners = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    propertyListeners = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
    return;
  }
  public function addPropertyChangeListener__Ljava_beans_PropertyChangeListener_2(listener: PropertyChangeListener): void {
    allPropertyListeners.add__Ljava_lang_Object_2(listener);
    return;
  }
  public function addPropertyChangeListener__Ljava_lang_String_2Ljava_beans_PropertyChangeListener_2(propertyName: String, listener: PropertyChangeListener): void {
    var listeners: ArrayList = ArrayList(propertyListeners.get__Ljava_lang_Object_2(propertyName));
    if (listeners === null)
      propertyListeners.put__Ljava_lang_Object_2Ljava_lang_Object_2(propertyName, listeners = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, [])));
    listeners.add__Ljava_lang_Object_2(listener);
    return;
  }
  public function firePropertyChange__Ljava_beans_PropertyChangeEvent_2(event: PropertyChangeEvent): void {
    if (event.getNewValue__() !== null && event.getOldValue__() !== null) {
      if (Object(event.getNewValue__()).equals__Ljava_lang_Object_2(event.getOldValue__()))
        return;
    }
    var propertyName: String = event.getPropertyName__();
    var listeners: ArrayList;
    if (propertyName !== null) {
      listeners = ArrayList(propertyListeners.get__Ljava_lang_Object_2(propertyName));
      if (listeners !== null) {
        var iter: Iterator = Iterator(listeners.iterator__());
        while (iter.hasNext__()) {
          var listener: PropertyChangeListener = PropertyChangeListener(iter.next__());
          if (listener !== null)
            listener.propertyChange__Ljava_beans_PropertyChangeEvent_2(event);
        }
      }
    }
    listeners = allPropertyListeners;
    if (listeners !== null) {
      var iter_1: Iterator = Iterator(listeners.iterator__());
      while (iter_1.hasNext__()) {
        var listener_1: PropertyChangeListener = PropertyChangeListener(iter_1.next__());
        if (listener_1 !== null)
          listener_1.propertyChange__Ljava_beans_PropertyChangeEvent_2(event);
      }
    }
    return;
  }
  public function firePropertyChange__Ljava_lang_String_2ZZ(propertyName: String, oldValue: Boolean, newValue: Boolean): void {
    this.firePropertyChange__Ljava_lang_String_2Ljava_lang_Object_2Ljava_lang_Object_2(propertyName, new Boolean__(new Arguments(java.lang.Boolean__.Boolean____Z, [oldValue])), new Boolean__(new Arguments(java.lang.Boolean__.Boolean____Z, [newValue])));
    return;
  }
  public function firePropertyChange__Ljava_lang_String_2II(propertyName: String, oldValue: int, newValue: int): void {
    this.firePropertyChange__Ljava_lang_String_2Ljava_lang_Object_2Ljava_lang_Object_2(propertyName, new Integer(new Arguments(java.lang.Integer.Integer__I, [oldValue])), new Integer(new Arguments(java.lang.Integer.Integer__I, [newValue])));
    return;
  }
  public function firePropertyChange__Ljava_lang_String_2Ljava_lang_Object_2Ljava_lang_Object_2(propertyName: String, oldValue: Object, newValue: Object): void {
    this.firePropertyChange__Ljava_beans_PropertyChangeEvent_2(new PropertyChangeEvent(source, propertyName, oldValue, newValue));
    return;
  }
  public function getPropertyChangeListeners__(): JavaArray {
    var result: JavaArray = new JavaArray("[Ljava/beans/PropertyChangeListener;").lengths(allPropertyListeners.size__());
    return JavaArray(JavaArray(allPropertyListeners.toArray___3Ljava_lang_Object_2(result)));
  }
  public function getPropertyChangeListeners__Ljava_lang_String_2(propertyName: String): JavaArray {
    var listeners: ArrayList = ArrayList(propertyListeners.get__Ljava_lang_Object_2(propertyName));
    if (listeners === null)
      return new JavaArray("[Ljava/beans/PropertyChangeListener;").lengths(0);
    var result: JavaArray = new JavaArray("[Ljava/beans/PropertyChangeListener;").lengths(listeners.size__());
    return JavaArray(JavaArray(listeners.toArray___3Ljava_lang_Object_2(result)));
  }
  public function removePropertyChangeListener__Ljava_beans_PropertyChangeListener_2(listener: PropertyChangeListener): void {
    allPropertyListeners.remove__Ljava_lang_Object_2(listener);
  }
  public function removePropertyChangeListener__Ljava_lang_String_2Ljava_beans_PropertyChangeListener_2(propertyName: String, listener: PropertyChangeListener): void {
    var listeners: ArrayList = ArrayList(propertyListeners.get__Ljava_lang_Object_2(propertyName));
    if (listeners !== null)
      listeners.remove__Ljava_lang_Object_2(listener);
  }
}
}
