package java.io {
import java.lang.IndexOutOfBoundsException;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ByteArrayInputStream extends InputStream {
  public var buf: JavaArray;
  public var pos: int;
  public var mark: int;
  public var count: int;
  public function ByteArrayInputStream___3B(buf: JavaArray): Object {
    this.buf = buf;
    this.count = buf.length;
    return this;
  }
  public function ByteArrayInputStream___3BII(buf: JavaArray, offset: int, length: int): Object {
    this.buf = buf;
    this.pos = offset > buf.length ? buf.length : offset;
    this.count = offset + length;
    if (this.count > buf.length)
      this.count = buf.length;
    this.mark = pos;
    return this;
  }
  public override function available__(): int {
    return count - pos;
  }
  public override function close__(): void {
  }
  public override function mark__I(readlimit: int): void {
    mark = pos;
  }
  public override function markSupported__(): Boolean {
    return true;
  }
  public override function read__(): int {
    return pos < count ? buf[pos++] & 0xFF : -1;
  }
  public override function read___3B(b: JavaArray): int {
    return this.read___3BII(b, 0, b.length);
  }
  public override function read___3BII(b: JavaArray, off: int, len: int): int {
    if (off < 0 || len < 0 || off >= b.length || off + len > b.length) {
      throw new IndexOutOfBoundsException(new Arguments(java.lang.IndexOutOfBoundsException.IndexOutOfBoundsException__, []));
    }
    if (pos >= count)
      return -1;
    if (len == 0)
      return 0;
    if (pos + len >= count)
      len = count - pos;
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(buf, pos, b, off, len);
    pos += len;
    return len;
  }
  public override function reset__(): void {
    pos = mark;
  }
  public override function skip__J(n: Number): Number {
    if (pos + n < count) {
      pos += n;
      return n;
    }
    var result: int = count - pos;
    pos = count;
    return result;
  }
  public function ByteArrayInputStream(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is JavaArray) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 3 && vargs[0] is JavaArray && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2]];
        break;
    }
    super();
    switch (id) {
      case 0:
        ByteArrayInputStream___3B(args0[0]);
        break;
      case 1:
        ByteArrayInputStream___3BII(args1[0], args1[1], args1[2]);
        break;
    }
  }
  public static const ByteArrayInputStream___3B : int = 0;
  public static const ByteArrayInputStream___3BII : int = 1;
}
}
