package java.io {
import java.lang.IllegalArgumentException;
import java.lang.System;
import java.lang.IndexOutOfBoundsException;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ByteArrayOutputStream extends OutputStream {
  public var buf: JavaArray;
  public var count: int;
  public function ByteArrayOutputStream__(): Object {
    return this;
  }
  public function ByteArrayOutputStream__I(size: int): Object {
    if (size < 0)
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__, []));
    buf = new JavaArray("[B").lengths(size);
    return this;
  }
  public override function close__(): void {
    super.close__();
    return;
  }
  private function grow__I(n: int): void {
    var newBuf: JavaArray = new JavaArray("[B").lengths((buf.length + n) * 2);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(buf, 0, newBuf, 0, count);
    buf = newBuf;
    return;
  }
  public function reset__(): void {
    count = 0;
    return;
  }
  public function size__(): int {
    return count;
  }
  public function toByteArray__(): JavaArray {
    var result: JavaArray = new JavaArray("[B").lengths(count);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(buf, 0, result, 0, count);
    return result;
  }
  public function toString__(): String {
    return Object(String).__init___3BII(buf, 0, count);
  }
  public override function write___3BII(b: JavaArray, off: int, len: int): void {
    if (off < 0 || len < 0 || off >= b.length || off + len > b.length) {
      throw new IndexOutOfBoundsException(new Arguments(java.lang.IndexOutOfBoundsException.IndexOutOfBoundsException__, []));
    }
    if (count + len > buf.length)
      this.grow__I(len);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(b, off, buf, count, len);
    count += len;
    return;
  }
  public override function write__I(b: int): void {
    if (count + 1 > buf.length)
      this.grow__I(1);
    buf[count++] = int(b);
    return;
  }
  public function ByteArrayOutputStream(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        args1 = [32];
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        ByteArrayOutputStream__I(args1[0]);
        ByteArrayOutputStream__();
        break;
      case 1:
        ByteArrayOutputStream__I(args1[0]);
        break;
    }
  }
  public static const ByteArrayOutputStream__ : int = 0;
  public static const ByteArrayOutputStream__I : int = 1;
}
}
