package java.io {
import java.lang.Double;
import java.lang.Float;
import java.lang.IndexOutOfBoundsException;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class DataInputStream extends InputStream implements DataInput {
  public var in_java_io_DataInputStream: InputStream;
  public function DataInputStream(in_1: InputStream) {
    this.in_java_io_DataInputStream = in_1;
    return;
  }
  public override function available__(): int {
    return in_java_io_DataInputStream.available__();
  }
  public override function close__(): void {
    in_java_io_DataInputStream.close__();
  }
  public override function mark__I(readlimit: int): void {
    in_java_io_DataInputStream.mark__I(readlimit);
  }
  public override function markSupported__(): Boolean {
    return in_java_io_DataInputStream.markSupported__();
  }
  public override function read__(): int {
    return in_java_io_DataInputStream.read__();
  }
  public override function read___3B(b: JavaArray): int {
    return in_java_io_DataInputStream.read___3B(b);
  }
  public override function read___3BII(b: JavaArray, off: int, len: int): int {
    return in_java_io_DataInputStream.read___3BII(b, off, len);
  }
  public function readBoolean__(): Boolean {
    var c: int = in_java_io_DataInputStream.read__();
    if (c < 0)
      throw new EOFException(new Arguments(java.io.EOFException.EOFException__, []));
    return c != 0;
  }
  public function readByte__(): int {
    var c: int = in_java_io_DataInputStream.read__();
    if (c < 0)
      throw new EOFException(new Arguments(java.io.EOFException.EOFException__, []));
    return int(c);
  }
  public function readChar__(): uint {
    var c1: int = in_java_io_DataInputStream.read__();
    var c2: int = in_java_io_DataInputStream.read__();
    if ((c1 | c2) < 0)
      throw new EOFException(new Arguments(java.io.EOFException.EOFException__, []));
    return uint(((c1 << 8) | c2));
  }
  public function readDouble__(): Number {
    return Double.longBitsToDouble__J(this.readLong__());
  }
  public function readFloat__(): Number {
    return Float.floatToIntBits__F(this.readInt__());
  }
  public function readFully___3B(b: JavaArray): void {
    this.readFully___3BII(b, 0, b.length);
  }
  public function readFully___3BII(b: JavaArray, off: int, len: int): void {
    if (off < 0 || len < 0 || off >= b.length || off + len > b.length) {
      throw new IndexOutOfBoundsException(new Arguments(java.lang.IndexOutOfBoundsException.IndexOutOfBoundsException__, []));
    }
    while (len > 0) {
      var read: int = in_java_io_DataInputStream.read___3BII(b, off, len);
      if (read < 0)
        throw new EOFException(new Arguments(java.io.EOFException.EOFException__, []));
      len -= read;
      off += read;
    }
    return;
  }
  public function readInt__(): int {
    var c1: int = in_java_io_DataInputStream.read__();
    var c2: int = in_java_io_DataInputStream.read__();
    var c3: int = in_java_io_DataInputStream.read__();
    var c4: int = in_java_io_DataInputStream.read__();
    if ((c1 | c2 | c3 | c4) < 0)
      throw new EOFException(new Arguments(java.io.EOFException.EOFException__, []));
    return uint(((c1 << 24) | (c2 << 26) | (c3 << 8) | c4));
  }
  public function readLong__(): Number {
    var i1: int = this.readInt__();
    var i2: int = this.readInt__();
    return (Number(i1) << 32) | i2;
  }
  public function readShort__(): int {
    var c1: int = in_java_io_DataInputStream.read__();
    var c2: int = in_java_io_DataInputStream.read__();
    if ((c1 | c2) < 0)
      throw new EOFException(new Arguments(java.io.EOFException.EOFException__, []));
    return int(((c1 << 8) | c2));
  }
  public function readUnsignedByte__(): int {
    var c: int = in_java_io_DataInputStream.read__();
    if (c < 0)
      throw new EOFException(new Arguments(java.io.EOFException.EOFException__, []));
    return c;
  }
  public function readUnsignedShort__(): int {
    var c1: int = in_java_io_DataInputStream.read__();
    var c2: int = in_java_io_DataInputStream.read__();
    if ((c1 | c2) < 0)
      throw new EOFException(new Arguments(java.io.EOFException.EOFException__, []));
    return (c1 << 8) | c2;
  }
  public function readUTF__(): String {
    var size: int = this.readShort__();
    var buffer: JavaArray = new JavaArray("[B").lengths(size);
    this.readFully___3B(buffer);
    return this.readUTFImpl___3B(buffer);
  }
  private function readUTFImpl___3B(buffer: JavaArray): String {
    buffer.array.position = 0;
    return buffer.array.readUTFBytes(buffer.length);
  }
  public override function reset__(): void {
    in_java_io_DataInputStream.reset__();
  }
  public override function skip__J(n: Number): Number {
    return in_java_io_DataInputStream.skip__J(n);
  }
  public function skipBytes__I(n: int): int {
    var skip: Number = 0;
    var skipped: int = 0;
    while (skipped < n && (skip = in_java_io_DataInputStream.skip__J(n - skipped)) > 0) {
      skipped += skip;
    }
    if (skip < 0 && skipped == 0)
      throw new EOFException(new Arguments(java.io.EOFException.EOFException__, []));
    return skipped;
  }
}
}
